#
#  Some of the peak sets have misalignment, that is, we can't trust
#    completely the peak1$iso nor pool1$m variables (both of which
#    supposedly point to the monoisotopic).
#
peakfit.align <- function(data) {
    m <- data$m.z * data$z - data$z # neutral mass
    
    # The spacings should be integers apart
    # "frac", short for fractional, is the common part after a decimal point
    # Want to find the mean of the fractional pieces
    temp1 <- m - round(m)  # produces the fractional pieces
    # The problem with temp1 si that when the mass is very close to an integer value
    #  then you get 100.01, 100.99, 102.01, 102.99
    #  and thus the fractional peices are .01, .99, .01, .99
    # Terry's solution to this is to add .5
    # There is nothing magical about .5, any value could be used
    # I'm (Jeanette) not sure that this is needed...have to chat with Terry again
    temp2 <- (m+.5) - round(m+.5)
    # There is an occasional peak in the list that does not belong, thus, use trimmed mean
    if (var(temp1) < var(temp2)) frac <- mean(temp1, .1) # 10% trimmed mean
    else frac <- mean(temp2, .1) - .5

    # Once the fractional part is known, can assign "true" peak centers
    centers <- seq(floor(min(m - frac)), ceiling(max(m-frac))) + frac

    iso.new <- round(approx(centers, 1:length(centers), m, rule=2)$y)
    #The iso.new marks each peak with an integer
    # Which of the new ones was most often called a "4" (monisotopic) by
    #   Chris?
    # tcount <- tapply(data$iso==4, iso.new, sum)
    # indx <- sort(unique(iso.new))  #the labels for tcount
    # iso.new <- 1 + iso.new - min(indx[which(tcount==max(tcount))])

    #Since Chris won't be generating all data for everyone
    #this needs to be generalized

    indx <- sort(unique(iso.new)) 
    iso.new <- match(iso.new,indx)
    
    iso.new
    }

    
