#
# Give the distribution for averagine, of a given mass
#  mass = mass of the protein or peptide
#  lower = don't chase any smaller probabilities than this
#
pdist <- function(mass, iso=isotope, lower=.001) {
    averagine <- c(4.9384, 7.7583, 1.3577, 1.4773, 0.0417)
    names(averagine) <- c("C", "H", "N", "O", "S")
    averagine.mass <- 111.1254   # average mass in Daltons

    temp <- round(isotope$iso.weight - isotope$atomic.weight)  #extra neutrons

    mtemp <- mass * averagine/averagine.mass
    lambda <- c(sum(mtemp* isotope$amount[temp==1]),
                sum(mtemp[4:5]* isotope$amount[temp==2]),
                mtemp[5]*isotope$amount[temp==4])

    # Now, lambda is the expected number of atoms with 1, 2, 4 extra masses
    # Set d1 = Poisson distribution of extra +1 isotopes, out to the limit
    #   selected
    # For simplicity, make d2 and d3 the same length, even though it's more
    #   than is needed, and fill them in with the appropriate distribution
    # 
    d1 <- dpois(0:qpois(1-lower, lambda[1]), lambda[1])
    d2 <- d3 <- rep(0., length(d1))
    
    temp <- floor(length(d1)/2)
    d2[1+ (0:temp)*2]  <- dpois(0:temp, lambda[2])
    
    temp <- floor(length(d1)/4)
    d3[1+ (0:temp)*4]  <- dpois(0:temp, lambda[3])

    # Now convolve
    zed <- outer(d1, d2, '*')
    indx <- row(zed)+ col(zed) -2
    d4 <- tapply(zed, pmin(indx,length(d1)+1), sum)

    zed <- outer(d4, d3, '*')
    indx <- row(zed)+ col(zed) -2
    d5 <- tapply(zed, pmin(indx,length(d1)+1), sum)
    d5[1:length(d1)]  # the last element has Pr(>=), not Pr(=)
    }
