\name{c.ls}
\alias{c.ls}
\title{
  Estimate C-coefficient for an ARP type by least squares
}
\description{
For a specified type of ARP and a fixed position tau, estimate the
C-coefficient by least squares.
}
\usage{
c.ls(type, smat, pos, tau, eps)
}
\arguments{
\item{type}{
Integer code of ARP type. 1=FS (Full-Sibs), 2=HS (Half-Sibs), 3=FC
(First-Cousins), 4=GP (GrandParent-Child), 5=AV (AVuncular pair,
i.e. uncle-nephew)
}
\item{smat}{
A matrix with allele sharing probabilities for affected relative pairs
(rows) at each position (columns) of a chromosomal region.
}
\item{pos}{
Vector of chromosome positions (in centimorgans) matching the columns of smat
}
\item{tau}{
Chromosome position for the trait-locus.
}
\item{eps}{
Epsilon, smoothing adjustment constant from Liang et al.(2001), as
used for adjustment within the Haldane mapping function.
}

}
\value{
Estimated C-coefficient
}
\section{Side Effects}{

}
\details{

}
\section{References}{

}
\seealso{
\code{\link{arp.ibd}}
}
\examples{

}
\keyword{}
% docclass is function
% Converted by Sd2Rd version 1.21.
