#$Author: sinnwell $
#$Date: 2004/10/07 21:54:40 $
#$Header: /people/biostat3/sinnwell/Projects/arp.gee/Make/RCS/relpair.type.q,v 1.1 2004/10/07 21:54:40 sinnwell Exp $
#$Locker:  $
#$Log: relpair.type.q,v $
#Revision 1.1  2004/10/07 21:54:40  sinnwell
#Initial revision
#
relpair.type <- function(ped, p1, p2){

if(p1==0 || p2==0) {
  type <- "NA"
  return(type)
}


person <- ped$per
father <- ped$father
mother <- ped$mother

lev      <- unique(person)
IDcodes  <- as.numeric(factor(c(father,mother,person),
                                 levels=lev,exclude=0))

IDcodes[is.na(IDcodes)] <- 0     
n <- length(IDcodes)
n <- n/3
father <- IDcodes[1:n]
mother <- IDcodes[(n+1):(2*n)]
person <- IDcodes[(2*n+1):(3*n)]

p1 <- (1:length(lev))[p1==lev]
p2 <- (1:length(lev))[p2==lev]

type <- NA


if(p1==p2){
  type <- "SELF"
  return(type)
}

# If parents of both subjects are missing, type = NA
if(father[p1]==0 && mother[p1]==0 && father[p2]==0 && mother[p2]==0){
  type <- "NA"
  return(type)
}

# Check for parent-offsrpring

if( (father[p1]!=0) && father[p1] == p2){
  type <- "PO"
  return(type)
}
if( (mother[p1]!=0) && mother[p1] == p2){
  type <- "PO"
  return(type)
}

if( (father[p2]!=0) && father[p2] == p1){
  type <- "PO"
  return(type)
}
if( (mother[p2]!=0) && mother[p2] == p1){
  type <- "PO"
  return(type)
}


# check for FS and HS by counting the number of parents in common

count.par <- (father[p1]==father[p2]) + (mother[p1]==mother[p2])
if(count.par==1){
  type <- "HS"
  return(type)
}

if(count.par==2){
   type="FS"
   return(type)
}


# check for Avuncular

# check if grandparents of p1 match parents of p2

f1 <- father[p1]
m1 <- mother[p1]

cf1 <- 1*(f1!=0 && (father[f1]!=0 & mother[f1]!=0))
cm1 <- 1*(m1!=0 && (father[m1]!=0 & mother[m1]!=0))

#if((cf1 + cm1)==0){
# type <- "NA"
#  return(type)
#}


if(cf1==1)
  {
    if( (father[f1] ==  father[p2])&(mother[f1] == mother[p2]) ){
      type <- "AV"
      return(type)
    }
  }
if(cm1==1)   
  {
    if( (father[m1] ==  father[p2])&(mother[m1] == mother[p2]) ){
      type <- "AV"
      return(type)
    }
  }


# check if parents of p1 match grandparents of p2

f1 <- father[p2]
m1 <- mother[p2]

cf1 <- 1*(f1!=0 && (father[f1]!=0 & mother[f1]!=0))
cm1 <- 1*(m1!=0 && (father[m1]!=0 & mother[m1]!=0))

#if((cf1 + cm1)==0){
# type <- "NA"
#  return(type)
#}


if(cf1==1)
  {
    if( (father[f1] ==  father[p1])&(mother[f1] == mother[p1]) ){
      type <- "AV"
      return(type)
    }
  }
if(cm1==1)   
  {
    if( (father[m1] ==  father[p1])&(mother[m1] == mother[p1]) ){
      type <- "AV"
      return(type)
    }
  }

# Grandparent-grandchild


# check if either of the paternal grandparents of p1 match p2


f1 <- father[p1]
if(f1!=0){
  if((father[f1] !=0) & father[f1] == p2){
    type <- "GP" 
    return(type)
  }
  if((mother[f1] !=0) & mother[f1] == p2){
    type <- "GP"
    return(type)
  }
}

# check if either of the maternal grandparents of p1 match p2

m1 <- mother[p1]
if(m1!=0){
  if((father[m1] !=0) & father[m1] == p2){
    type <- "GP"
    return(type) 
  }
  if((mother[m1] !=0) & mother[m1] == p2){
    type <- "GP"
    return(type)
  }
}


# check if either of the paternal grandparents of p2 match p1

f2 <- father[p2]
if(f2!=0){
  if((father[f2] !=0) & father[f2] == p1){
    type <- "GP"
    return(type) 
  }
  if((mother[f2] !=0) & mother[f2] == p1){
    type <- "GP"
    return(type)
  }
}

# check if either of the maternal grandparents of p2 match p1

m2 <- mother[p2]
if(m2!=0){
  if((father[m2] !=0) & father[m2] == p1){
    type <- "GP"
    return(type) 
  }
  if((mother[m2] !=0) & mother[m2] == p1){
    type <- "GP"
    return(type)
  }
}


# Cousins

# check if mother of p1 and mother of p2 are full sibs

m1 <- mother[p1]
m2 <- mother[p2]
m1;m2

if((m1!=0) && (m2!=0) && (father[m1]!=0) && (father[m2]!=0) && (mother[m1]!=0) && (mother[m2]!=0) &&
    (father[m1]==father[m2]) && (mother[m1]==mother[m2]) ){
  type="FC"
  return(type)
}

# check if mother of p1 and father of p2 are full sibs

m1 <- mother[p1]
f2 <- father[p2]
m1;f2

if((m1!=0) && (f2!=0) && (father[m1]!=0) && (father[f2]!=0) && (mother[m1]!=0) && (mother[f2]!=0) &&
    (father[m1]==father[f2]) && (mother[m1]==mother[f2]))   {
  type <- "FC"
  return(type)
}

# check if father of p1 and mother of p2 are full sibs

f1 <- father[p1]
m2 <- mother[p2]
f1;m2

if((f1!=0) && (m2!=0) && (father[f1]!=0) && (father[m2]!=0) && (mother[f1]!=0) && (mother[m2]!=0) &&
    (father[f1]==father[m2]) && (mother[f1]==mother[m2]))   {
  type <- "FC"
  return(type)
}


# check if father of p1 and father of p2 are full sibs

f1 <- father[p1]
f2 <- father[p2]
f1;f2

if((f1!=0) && (f2!=0) && (father[f1]!=0) && (father[f2]!=0) && (mother[f1]!=0) && (mother[f2]!=0) &&
    (father[f1]==father[f2]) && (mother[f1]==mother[f2]))   {
  type <- "FC"
  return(type)
}


return("NA")

}
