

ibd.peaks <- function(pos, ibd, top.pct=0.4, end.cut=10, near.rng=10) {
  # give the pos of the peaks in function defined by its points
  # 1) only work with candidates that are in the top 100*top.pct% of ibd-range
  # 2) don't accept a pt on the end if high outside an end cutoff (end.cut)
  # 3) for all high-IBD regions, of the pts with d2<0, find clusters of
  ##   those which are all within near.rng of each other, choose highest of those

  # cut ranges are in cMorgans
  
  n <- length(ibd)
  d1 <- (ibd[2:n] - ibd[1:(n-1)])/(pos[2:n] - pos[1:(n-1)])
  d2 <- c(0,(d1[2:(n-1)]-d1[1:(n-2)])/(pos[2:(n-1)] - pos[1:(n-2)]),0)
 
  
  min.ht <- (1-top.pct)*(max(ibd)-min(ibd))+ min(ibd)
  tmp <- ibd>min.ht
  group <- cumsum(!tmp)[tmp]
  df <- data.frame(group=group,pos.top=pos[tmp],d2.top=d2[tmp],ibd.top=ibd[tmp])

  # remove points w/in end.cut of the end
  out.ends <- (df$pos.top < (min(pos)+end.cut)) | (df$pos.top > (max(pos)-end.cut))
  df <- df[!out.ends,]
  df$group <- as.numeric(factor(df$group))
                 
  if(nrow(df)) {
    pick.peaks <- function(indx, df.sub, cut) {

      pos.sub <- df.sub$pos.top[indx]
      ibd.sub <- df.sub$ibd.top[indx]
      d2.sub <- df.sub$d2.top[indx]

      d2.is.neg <- d2.sub<0
      k <- length(indx)
      pos.peak <- numeric(0)
      if(sum(d2.is.neg)>1) {
        # select pos.pts where fctn is concave (d2<0)
        pos.pts <- pos.sub[d2.is.neg]
        
        # make cluster begin and end pts,
        # where successive pos.pts are closer than 'cut'
        right <- 2:length(pos.pts)
        delta <- pos.pts[right] - pos.pts[right-1]
        zed <- right[delta>cut]
        if(length(zed)) {
          cluster.begin <- c(1,zed)
          cluster.end <- c(zed-1,length(pos.pts))
          
          # now choose the pos within clusters with the max ibd value.
          for (i in (1:length(cluster.begin))) {
            start <- (1:k)[pos.sub==pos.pts[cluster.begin[i]]]
            end <- (1:k)[pos.sub==pos.pts[cluster.end[i]]]
            pos.peak <- c(pos.peak,pos.sub[start:end][ibd.sub[start:end]==max(ibd.sub[start:end])])
          }
        } 
      }
      if(length(pos.peak)==0) { pos.peak <- pos.sub[ibd.sub==max(ibd.sub)] }

      return(pos.peak)
    }

    indx <- 1:nrow(df)
    pos.peaks <- tapply(X=indx,IND=df$group, FUN=pick.peaks, df[,-1], near.rng)
    
    pos.peaks <- unlist(pos.peaks)

  } else {pos.peaks <- NA }

  return(pos.peaks)

}
