#$Author: schaid $
#$Date: 2005/01/13 23:28:37 $
#$Header: /people/biostat3/sinnwell/Projects/arp.gee/Make/RCS/get.genehunter.ibd.q,v 1.4 2005/01/13 23:28:37 schaid Exp $
#$Locker:  $
#$Log: get.genehunter.ibd.q,v $
#Revision 1.4  2005/01/13 23:28:37  schaid
#*** empty log message ***
#
#Revision 1.3  2005/01/13 23:23:15  schaid
#add mapfun as option
#
#Revision 1.2  2003/01/18 19:21:44  schaid
#added more cleanup to remove Genehunter files after get.genehunter.ibd
#
#Revision 1.1  2003/01/15 16:30:18  schaid
#Initial revision
#

get.genehunter.ibd <- function(file.pre, file.par, mapfun="kosambi", file.ibd=NULL){

if(missing(file.pre))
  stop("required argument file.pre is missing")

if(missing(file.par))
  stop("required argument file.par is missing")

map.funs <- c("kosambi","haldane")
which.fun <- pmatch(mapfun, map.funs)
if(is.na(which.fun)) stop(paste("Map function",mapfun,"not allowed")) else
mf <- map.funs[which.fun]

# clean dir before running GH:
unix("rm screen")
unix("rm ghDumpIbd.out")
unix("rm haplo.dump")
unix("rm ibd.out")

# dump GH input file
cat("photo ghDumpIbd.out\n",file="ghDumpIbd.in",append=FALSE)
cat("ps off\n",file="ghDumpIbd.in",append=TRUE)
cat("count rec off\n",file="ghDumpIbd.in",append=TRUE)
cat("haplotype off\n",file="ghDumpIbd.in",append=TRUE)
cat("map function",mf,"\n",file="ghDumpIbd.in",append=TRUE)
cat("load markers",file.par," \n",file="ghDumpIbd.in",append=TRUE)
cat("skip large off\n",file="ghDumpIbd.in",append=TRUE)
cat("scan pedigrees ", file.pre," \n",file="ghDumpIbd.in",append=TRUE)
cat("dump ibd\n",file="ghDumpIbd.in",append=TRUE)
cat("ibd.out\n",file="ghDumpIbd.in",append=TRUE)
cat("quit\n",file="ghDumpIbd.in",append=TRUE)

# run GH to get IBD's
unix("gh < ghDumpIbd.in > screen")

# read in GH IBD output file
ibd <- get.object("ibd.out",parse.genehunter.ibd.pl)

if(!is.null(file.ibd)) unix(paste("mv ibd.out ",file.ibd)) else
  unix("rm ibd.out")

# clean dir after  running GH:
unix("rm screen")
unix("rm ghDumpIbd.in")
unix("rm ghDumpIbd.out")
unix("rm haplo.dump")


return(ibd)

}

