#$Date: 2005/01/31 17:02:37 $
#$Header: /people/biostat3/sinnwell/Projects/arp.gee/Make/RCS/arp.ibd.fitter.q,v 1.3 2005/01/31 17:02:37 sinnwell Exp $
#$Locker:  $
#$Log: arp.ibd.fitter.q,v $
#Revision 1.3  2005/01/31 17:02:37  sinnwell
#lamda to lambda for data.frame label
#
#Revision 1.2  2004/12/30 22:21:42  sinnwell
#comment out warnings, not necessary with multiple starting values
#put non-convergence messages in the print method
#
#Revision 1.1  2004/11/22 23:01:11  sinnwell
#Initial revision
#
#Revision 1.3  2004/10/10 21:16:29  schaid
#moved class definition to immediately after creation of 'save' objects, so that the object is created even if the function quits early due to non-convergence.
#
#Revision 1.2  2004/10/08 17:34:18  schaid
#added measure of goodness of fit to returned object
#
#Revision 1.1  2004/10/07 21:50:45  sinnwell
#Initial revision
#
arp.ibd.fitter <- function(ibd.obj, model="C", tau.init=NA, c.init=NA, lambda.init=NA,
                    ci.prob=0.95, max.iter=50,tol=1e-4,eps=1, print.iter=FALSE)


## Schaid, DJ and Sinnwell, JP
## Mayo Clinic Rochester, MN
## Div. of Biostatistics

{  
 # do the gee fitting steps of arp.ibd  

# type is factor, make integer version and counts of used types
  type <- factor(ibd.obj$type, levels=c("FS","HS","FC","GP","AV"))

# make index vectors which to subset on if any na's
  zed.rows <- is.na(type) | is.na(ibd.obj$ped) | apply(is.na(ibd.obj$smat), 1, any)

  type <- type[!zed.rows]
 
# subset rows(pairs) and columns (positions) from missings
# then order by type (not by ped id) 
  ord <- order(type)
  smat <- ibd.obj$smat[!zed.rows,][ord,]
  ped <- ibd.obj$ped[!zed.rows][ord]
  type <- type[ord]

  pos <- ibd.obj$pos  
  nPos <- length(pos)
  pedIndx <- as.numeric(factor(ped))-1
  nPed <- length(unique(pedIndx))

  n.type <- table(type)
  utype <- unique(type)
  int.type <- as.integer(utype)
 

  if( any(is.na(pos)))
    stop("pos vector has missing data")

  if( nPos != ncol(smat))
    stop("Length of pos vector not equal to ncol of smat")
  

  if(print.iter){
    verbose <- 1
  } else {
    verbose <- 0
  }

  # Compute init value for tau if none given

  if(is.na(tau.init)) {
    tmp <- apply(smat,2,mean)
    tau.init <- pos[tmp==max(tmp)]
  }


  if(tau.init>max(pos) | tau.init<min(pos))
    stop("tau.init is out of range.")


  if(model=="C"){
  
    if(all(!is.na(c.init)) & (length(c.init) != length(utype)))
      stop("Number of C coefficients and ARP types don't match.")

    # starting values for c's, based on all sharing stats
    #   and distance from tau.
   
    if(any(is.na(c.init))){
      
      c.init <- numeric(length(int.type))

      for(i in 1:length(int.type)){

        c.init[i] <-  c.ls(type=int.type[i], smat[as.integer(type)==int.type[i],], pos, tau=tau.init, eps=eps)
      }

    }

    
    gamma <- c(tau.init, c.init)
    n.gamma <- length(gamma)
    

    save <-  .C("gee_arp",
                pos=as.double(pos),         
                n.pos=as.integer(nPos), 
                Svec=as.double(as.vector(smat)), 
                n.pair=as.integer(nrow(smat)),   
                pedIndx=as.integer(pedIndx),
                nPed=as.integer(nPed),
                type=as.integer(int.type),          
                len.type=as.integer(length(int.type)),
                n.type=as.integer(n.type[int.type]),
                iter=as.integer(0),
                max.iter=as.integer(max.iter),
                tol=as.double(tol),
                eps=as.double(eps), 
                u.scores=as.double(rep(0,(n.gamma))),
                gamma = as.double(gamma),
                n.gamma =as.integer(n.gamma),
                info.vec = as.double(numeric(n.gamma*n.gamma)),
                info.robust.vec = as.double(numeric(n.gamma*n.gamma)),
                rank=as.integer(n.gamma),
                converge=as.integer(0),
                alias=as.integer(numeric(n.gamma)),
                verbose=as.integer(verbose),
                PACKAGE='arp.gee')
                
    
    # converge: 0 failed to converge within max.iter
    #           1 converged
    #          -1 tau is out of range of pos
    #          -2 one or more c-coef out of range

 
   if(exists("is.R") && is.function(is.R) && is.R()) {
       class(save) <- "arp.ibd"
     } else {
       oldClass(save) <- "arp.ibd"
     }
    
    save$type <- utype
    save$model <- model
    save$ci.prob <- ci.prob
    
    if(save$converge == -1){
      #warning("tau is out of range.")
      return(save)
     }
    if(save$converge == -2){
      #warning(" one or more c-coef is out of range.")
      return(save)
     }
    if(save$converge == 0){
      #warning("Failed to converge within max.iter and specified tol")
      return(save)
     }


    save$info.robust <- matrix(save$info.robust.vec, ncol=n.gamma)
    save$info <- matrix(save$info.vec, ncol=n.gamma)
    
    tmp <- solve(save$info) 
    save$var <- tmp %*% save$info.robust %*% tmp
    
    se <- sqrt(diag(save$var))
    
       # compute CI's, default ci.prob =.95
    z <-  -1*qnorm((1-ci.prob)/2)

    tbl <- cbind(save$gamma, save$gamma - z*se, save$gamma + z*se)
    
    lambda <- NULL
    lambda.low <- NULL
    lambda.up <- NULL

    for(i in 1:length(utype)){
      lambda <- c(lambda, c2lambda(int.type[i], save$gamma[i+1]))
      lambda.low <- c(lambda.low, c2lambda(int.type[i], tbl[i+1,2]))
      lambda.up  <- c(lambda.up,  c2lambda(int.type[i], tbl[i+1,3]))
    }
 
    lambda <- cbind(lambda, lowerCI=lambda.low,upperCI= lambda.up)

    if(sum(save$alias)) {
      tbl <- cbind(tbl, save$alias)
      dimnames(tbl) <- list(c("tau",paste("C",as.character(utype),sep="-")), c("estimate","lowerCI","upperCI", "is.aliased"))
      lambda <- cbind(lambda, save$alias)
      dimnames(lambda)[[2]] <- c(dimnames(lambda)[[2]], "is.aliased")
    }  else 
    {
      dimnames(lambda)[[1]]<- paste("lambda",as.character(utype),sep="-") 
      dimnames(tbl) <- list(c("tau",paste("C",as.character(utype),sep="-")), c("estimate","lowerCI","upperCI"))
    }
    

    save$lambda <- lambda
    save$tbl <- tbl
    
    save$n.pos <- NULL
    save$Svec <- NULL
    save$pedIndx <- NULL
    save$len.type <- NULL
    save$tol <- NULL
    save$n.gamma <- NULL
    save$verbose <- NULL
    save$info.vec <- NULL
    save$info.robust.vec <- NULL
    
  }

  
  if(model=="LAMBDA"){
    
      # tau.init is set above, set lambda.init
      # use weighted avg of lambdas from c2lambda on c's

    if(is.na(lambda.init)) {

      lam.vec <- numeric(length(int.type))
      for(i in 1:length(int.type)){
        lam.vec[i] <- c2lambda(int.type[i], c.ls(type=int.type[i],
                           smat[as.integer(type)==int.type[i],], pos, tau=tau.init, eps=eps))
      }
      lambda.init <- sum(lam.vec*n.type[int.type])/sum(n.type)
    }


    if(lambda.init <= 0 )
      stop("lambda.init is out of range.  Must be > 0 ")

    gamma <- c(tau.init, lambda.init)
    n.gamma <- length(gamma)


    if(n.gamma != 2) stop("LAMBDA model must have 2 parameters")
    
    save <-  .C("gee_arp_lambda",
                pos=as.double(pos),         
                n.pos=as.integer(nPos), 
                Svec=as.double(as.vector(smat)), 
                n.pair=as.integer(nrow(smat)),   
                pedIndx=as.integer(pedIndx),
                nPed=as.integer(nPed),
                type=as.integer(int.type),          
                len.type=as.integer(length(int.type)),
                n.type=as.integer(n.type[int.type]),       
                iter=as.integer(0),
                max.iter=as.integer(max.iter),
                tol=as.double(tol),
                eps=as.double(eps), 
                u.scores=as.double(rep(0,2)),
                gamma = as.double(gamma),
                info.vec = as.double(numeric(n.gamma*n.gamma)),     
                info.robust.vec = as.double(numeric(n.gamma*n.gamma)),
                rank=as.integer(n.gamma),
                converge=as.integer(0),
                alias=as.integer(numeric(n.gamma)),
                verbose=as.integer(verbose),
                PACKAGE='arp.gee')

   if(exists("is.R") && is.function(is.R) && is.R()) {
       class(save) <- "arp.ibd"
     } else {
       oldClass(save) <- "arp.ibd"
     }

    save$type <- utype
    save$model <- model
    save$ci.prob <- ci.prob
    
    if(save$converge == -1){
      #warning("tau is out of range.")
      return(save)
     }
    if(save$converge == -2){
      #warning(" one or more c-coef is out of range.")
      return(save)
     }  
    if(save$converge == 0){
      #warning("Failed to converge within max.iter and specified tol")
      return(save)
     }

    
    save$info.robust <- matrix(save$info.robust.vec, ncol=n.gamma)
    save$info <- matrix(save$info.vec, ncol=n.gamma)
    
    tmp <- solve(save$info) 
    save$var <- tmp %*% save$info.robust %*% tmp
    
    se <- sqrt(diag(save$var))
    
    z <- -1*qnorm((1-ci.prob)/2)
    tbl <- cbind(save$gamma, save$gamma - z*se, save$gamma + z*se)
    if(sum(save$alias)) {
      tbl <- cbind(tbl, save$alias)
      dimnames(tbl) <- list(c("tau","lambda"), c("estimate","lowerCI","upperCI", "is.aliased"))
    }    else 
   {
      dimnames(tbl) <- list(c("tau","lambda"), c("estimate","lowerCI","upperCI"))
    }

    save$tbl <- tbl
      
    save$n.pos <- NULL
    save$Svec <- NULL
    save$pedIndx <- NULL
    save$len.type <- NULL
    save$tol <- NULL
    save$n.gamma <- NULL
    save$verbose <- NULL
    save$info.vec <- NULL
    save$info.robust.vec <- NULL
    
  }


  gof <- arp.gof(ibd.obj, save)
  save$gof <- gof

  return(save)
}
  


