#$Author: sinnwell $
#$Date: 2004/10/07 22:11:49 $
#$Header: /people/biostat3/sinnwell/Projects/arp.gee/Make/RCS/arp.fit.q,v 1.1 2004/10/07 22:11:49 sinnwell Exp $
#$Locker:  $
#$Log: arp.fit.q,v $
#Revision 1.1  2004/10/07 22:11:49  sinnwell
#Initial revision
#
arp.fit <- function(type, pos, tau, c.coef, eps){

  dist  <-  pos - tau;

  delta <- ifelse(abs(dist) <= eps,(dist*dist)/(2.0*eps) + eps/2.0, abs(dist))
 
 
  switch(type,
    { #full sibs
      a <- 1.0;
      x <- exp(-.04 * delta);
    },
    { # half-sibs
      a <- 0.5;
      x <- exp(-.04 * delta);
    },
     { #first cousins
      a <- 0.25;
      x <- 0.5*exp(-.04*delta) + 0.33333*exp(-.06*delta) + 0.16666*exp(-.08*delta);
    },
   { # grandparent - grandchild
      a  <-  0.5;
      x  <-  exp(-.02*delta);
    },
   { # uncle-nephew
      a  <-  0.5;
      x  <-  0.5*exp(-.04*delta) + 0.5*exp(-.06*delta);
   }
 )


  s.fit <- a + x * c.coef

 
  return(list(s.fit=s.fit, pos=pos))

}
