\name{lambda.equal.arp}
\alias{lambda.equal.arp}
\title{
  Score statistic to test equal lambda's for different type of ARP's
}
\description{
Compute a robust score statistic to test whether the lambda's are
equal across different types of ARP's
}
\usage{
lambda.equal.arp(ibd.obj, fit.lambda)
}
\arguments{
\item{ibd.obj }{
An object of the 'ibd.share' class, a list which contains the
following elements: \$smat - a matrix having allele sharing probabilities
for affected relative pairs (rows) at each position (columns) of a 
chromosomal region; \$type - vector of affected relative pair types;
\$ped - vector of pedigree id's; and \$pos - vector of chromosome positions (in
centimorgans) matching the columns of \$smat.
}
\item{fit.lambda }{
An object of class arp.ibd resulting from the function arp.ibd with
model="Lambda" (e.g. the constrained model).
contrained model).
}

}
\value{

\item{stat}{
stat = chi-square statistic
}
\item{df}{
df = degrees-of-freedom
}
\item{pval}{
pval = p-value
}
}
\section{Side Effects}{

}
\details{
Use both the input (ibd.obj) and output (fit.lambda) of the function
arp.ibd, with the constrained model="Lambda", to compute the score
statistic to test if the lambda's are equal across the different types
of ARP's.
}
\section{References}{

}
\seealso{
\code{\link{arp.ibd}}
}
\examples{
# load an ibd.share object, fit the lambda model, test it for equality
# C coeffs.  lambda.equal.arp runs C model to compare against.
setupData(example.share)
fit.lambda <- arp.ibd(example.share, model="lambda")
stat.equal <- lambda.equal.arp(example.share, fit.lambda) 
unlist(stat.equal)
}
\keyword{}
% docclass is function
% Converted by Sd2Rd version 1.21.
