%  $Author: sinnwell $ 
%  $Date: 2004/12/29 20:53:38 $ 
%  $Header: /people/biostat3/sinnwell/Projects/arp.gee/Make/RCS/example.share.Rd,v 1.1 2004/12/29 20:53:38 sinnwell Exp $
%  $Locker:  $ 


\name{example.share}
\alias{example.share}
\title{
  Example IBD sharing values for Affected Relative Pairs
}
\description{
  Example IBD sharing values for Affected Relative Pairs.
  The data comes from a Prostate Cancer study with medium to large
  pedigrees.  The IBD values are for individuals of 3 common ARP
  types on one particular chromosome.
}
\usage{
data(example.share)
}
\format{
\item{smat}{
  Matrix of estimated IBD sharing values, arranged by ARP type (rows)
  and chromosome position (columns).  Rows are sorted by ARP type and
  then pedigree.  
}
\item{ ped }{
  Pedigree code for all ARPs, elements correspond to rows in smat.  Many
  relative pairs from a pedigree may be included, but they don't appear
  together in smat.  82 pedigrees are in this data set.
}
\item{ type }{
  The ARP type, as a factor, of all ARPs in the order they are stored in
  smat.  FS: 206; FC: 112; AV: 26.
  
}
\item{ pos }{
  61 chromosome positions, measured in centimorgans from one end.  They
  serve as column names of smat.
}
}

\source{
  Dataset kindly provided by S. N. Thibodeau.  
}
\section{References}{

}

\keyword{datasets}
% docclass is function
