\name{arp.fit}
\alias{arp.fit}
\title{
  Fitted values for an ARP type
}
\description{
Calculate fitted values for an Affected Relative Pair type, given
parameters estimated from arp.ibd.  
}
\usage{
arp.fit(type, pos, tau, c.coef, eps)
}
\arguments{
\item{type}{
Integer code of ARP type. 1=FS (Full-Sibs), 2=HS (Half-Sibs), 3=FC
(First-Cousins), 4=GP (GrandParent-Child), 5=AV (AVuncular pair
i.e. uncle-nephew)
}
\item{pos}{
Vector of chromosome positions, in centimorgans
}
\item{tau}{
Estimated trait-locus position
}
\item{c.coef }{
Locus effect coefficient for the ARP type
}
\item{eps}{
Smoothing parameter used by Liang et al., as used in the Haldane
mapping function.
}
}
\value{
A list with the following vectors

\item{s.fit}{
Vector of fitted values of allele sharing, specific to ARP type
}
\item{pos}{
Vector of chromosome positions, in centimorgans (same as input vector)
}
}
\section{Side Effects}{

}
\details{

}
\section{References}{

}
\seealso{

}
\examples{

}
\keyword{}
% docclass is function
% Converted by Sd2Rd version 1.21.
