#$Author: sinnwell $
#$Date: 2004/11/30 17:04:36 $
#$Header: /people/biostat3/sinnwell/Projects/arp.gee/Make/RCS/summary.arp.ibd.q,v 1.4 2004/11/30 17:04:36 sinnwell Exp $
#$Locker:  $
#$Log: summary.arp.ibd.q,v $
#Revision 1.4  2004/11/30 17:04:36  sinnwell
#one print.banner to printBanner
#
#Revision 1.3  2004/11/17 17:17:01  sinnwell
#update for arp.ibd to arp.ibd.fitter
#also, fix a couple bugs
#
#Revision 1.2  2004/10/08 18:28:32  sinnwell
#add digits
#
#Revision 1.1  2004/10/07 21:54:13  sinnwell
#Initial revision
#


summary.arp.ibd <- function(object, digits = max(options()$digits - 4, 5), ...)
  
# Sinnwell, JP 6/2004
  
{
    # show detailed results of the estimation process
  if(object$converge==1) {
    printBanner("Details per starting position")
    print(object$summary.df)
  } else cat("\n Non-convergence with position: ", object$summary.df$tau.est,"\n")
  
  pairs.count <- matrix(object$n.type, nrow=1)
  dimnames(pairs.count) <- list("n.pairs", as.character(object$type))
  
  cat("\n Number of pedigrees:", object$nPed, "\n")
  cat(" epsilon: ", object$eps, "\n")
  cat(" model: ", object$model, "\n")
    
  if(object$converge==1) cat(" Converged after  ", object$iter, " N-R iterations.")
  else cat(" No Convergence after:", object$iter, " N-R iterations.")
  cat("\n\n")
    
  printBanner("Number of pairs for each relative pair type.")
  print(pairs.count)
  cat("\n")
  tmp <- paste("Parameter estimates and", as.character(100*object$ci.prob), "% confidence intervals")
  printBanner(tmp)
  print(object$tbl, digits=digits)
    
  cat("\n")
  
  if(object$converge==1 && object$model=="C") {
    printBanner("Lambdas transformed from estimated Cs")
    print(object$lambda, digits=digits)
  }
  
  invisible(object)
}
