#$Author: sinnwell $
#$Date: 2005/07/06 13:19:43 $
#$Header: /people/biostat3/sinnwell/Projects/arp.gee/Make/RCS/mergeIbdCovar.merlin.q,v 1.1 2005/07/06 13:19:43 sinnwell Exp $
#$Locker:  $
#$Log: mergeIbdCovar.merlin.q,v $
#Revision 1.1  2005/07/06 13:19:43  sinnwell
#Initial revision
#
mergeIbdCovar.merlin <- function(ibd.dat, covar.dat) {

# merge ibd  and covar data based on FAMILY, ID1, ID2 in ibd.dat,
# and ped, per in covar.dat

   ibd.dat <- as.data.frame(ibd.dat)

   nm.ibd.dat <- names(ibd.dat)
   if(sum(nm.ibd.dat=="FAMILY")!=1)  stop("Need one columnin ibd.dat named 'FAMILY'")
   if(sum(nm.ibd.dat=="ID1")!=1) stop("Need one column in ibd.dat named 'ID1'")
   if(sum(nm.ibd.dat=="ID2")!=1) stop("Need one column in ibd.dat named 'ID2'")

   nm.cov.dat <- names(covar.dat)
   if(sum(nm.cov.dat=="ped")!=1) stop("Need one column in covar.dat named 'ped'")
   if(sum(nm.cov.dat=="per")!=1) stop("Need one column in covar.dat named 'per'")
 

   id.ibd <- data.frame(as.numeric(ibd.dat$FAMILY),
                        as.numeric(ibd.dat$ID1),
                        as.numeric(ibd.dat$ID2))
   names(id.ibd) <- c("FAMILY","ID1","ID2")
   id.ibd <- cbind(id.ibd,rownum=1:nrow(id.ibd))


   id.dat <- data.frame(as.numeric(covar.dat$ped),
                        as.numeric(covar.dat$per))
   names(id.dat) <- c("ped","per")

   id.dat <- cbind(id.dat, indx=(1:nrow(id.dat)))

   m1 <- merge(id.ibd,id.dat,by.x=c(1,2),by.y=c(1,2),all.x=T)
   m1 <- m1[order(m1$rownum),]

   m2 <- merge(id.ibd,id.dat,by.x=c(1,3),by.y=c(1,2),all.x=T)
   m2 <- m2[order(m2$rownum),]

   indx1 <- m1$indx
   indx2 <- m2$indx

   x1 <- covar.dat[indx1, -pmatch(c("ped","per"),names(covar.dat))]
   x2 <- covar.dat[indx2, -pmatch(c("ped","per"),names(covar.dat))]

   nm <- names(x1)
   name1 <- names(ibd.dat)
   name2 <- paste(nm,1,sep=".")
   name3 <- paste(nm,2,sep=".")

   df <- data.frame(ibd.dat,x1,x2)
   names(df) <- c(name1,name2,name3)

   return(df)
}
