#$Author: sinnwell $
#$Date: 2005/01/13 20:38:33 $
#$Header: /people/biostat3/sinnwell/Projects/arp.gee/Make/RCS/ibd.df.q,v 1.5 2005/01/13 20:38:33 sinnwell Exp $
#$Locker:  $
#$Log: ibd.df.q,v $
#Revision 1.5  2005/01/13 20:38:33  sinnwell
#F to FALSE
#
#Revision 1.4  2004/12/29 22:53:49  sinnwell
#R doesn't handle ibd.df class coercion back to data.frame,
#so if R, don't do oldClass, keep as data.frame
#
#Revision 1.4  2004/12/14 20:23:52  sinnwell
#usable for R, still gives warning about NAs.  Coercion problem fixed
#
#Revision 1.3  2004/08/03 21:17:28  sinnwell
#add I() for per1 and per2 because in R they turn to factors in ifelse()
#
#Revision 1.2  2004/01/13 20:52:10  mcdonnel
#Shannon McDonnell modified on 1/13/04 to comment out two lines that removed parent-offspring pairs.  These pairs are now included in the Splus ibd object.
#
#Revision 1.1  2003/01/15 16:30:28  schaid
#Initial revision
#
ibd.df <- function(ibd.dat){

# Arguments: ibd.dat is a data.frame as created by 
# finish.object.genehunter.ibd. The returned object is of class
# ibd.df, which represents and "ibd data frame", where the ibd info
# is stored in matrices, and these matrices are items in the returned
# ibd.df

# Create and return a dataframe of ped, per1, per2, and ibd info

# We decided to comment out these lines 1/13/04.
# parent-offspring pairs are now kept in the splus ibd object
# remove pairs with prior(ibd=1)=1, which are parent-offspring pairs
# zed <- ibd.dat$prior1==1
# ibd.dat <- ibd.dat[!zed,]

#  Change vec's to matrices of pairs (rows) by pos (cols)

pos <- unique(ibd.dat$pos)
npos <- length(pos)

prior0 <-t(matrix(ibd.dat$prior0,nrow=npos, byrow=FALSE))
dimnames(prior0) <- list(1:nrow(prior0),pos)
oldClass(prior0) <- "model.matrix"

prior1 <-t(matrix(ibd.dat$prior1,nrow=npos, byrow=FALSE))
dimnames(prior1) <- list(1:nrow(prior1),pos)
oldClass(prior1) <- "model.matrix"

prior2 <-t(matrix(ibd.dat$prior2,nrow=npos, byrow=FALSE))
dimnames(prior2) <- list(1:nrow(prior2),pos)
oldClass(prior2) <- "model.matrix"

post0 <-t(matrix(ibd.dat$post0,nrow=npos, byrow=FALSE))
dimnames(post0) <- list(1:nrow(post0),pos)
oldClass(post0) <- "model.matrix"

post1 <-t(matrix(ibd.dat$post1,nrow=npos, byrow=FALSE))
dimnames(post1) <- list(1:nrow(post1),pos)
oldClass(post1) <- "model.matrix"

post2 <-t(matrix(ibd.dat$post2,nrow=npos, byrow=FALSE))
dimnames(post2) <- list(1:nrow(post2),pos)
oldClass(post2) <- "model.matrix"

# Get ped,per1,per2 id's for a single map position ( pos=min(pos) )

min.pos <- min(pos)
zed <- ibd.dat$pos==min.pos

ped <-  ibd.dat$ped[zed]
tmp1 <- ibd.dat$per1[zed]
tmp2 <- ibd.dat$per2[zed]

per1 <- ifelse(tmp1 < tmp2, tmp1, tmp2)
per2 <- ifelse(tmp2 > tmp1, tmp2, tmp1)

# Calculate coefficients of ibd, and classify into pair types.
# The order of pair type codes is from largest to smallest values of
# P(ibd=1), with sibs higher than other types that have P(ibd=1)=0.5.
# So, for example, sibs have type=1, avuncular type = 2, cousins type = 3, etc.

t0 <- ibd.dat$prior0[zed]
t1 <- ibd.dat$prior1[zed]
t2 <- ibd.dat$prior2[zed]
tmp <- unique.data.frame(data.frame(t0,t1,t2))
ord <- rev(order(tmp[,2],tmp[,3]))
c.coef <- tmp[ord,]

pair.type <- 1*(t0 ==c.coef[1,1]  & t1 ==c.coef[1,2]   & t2 ==c.coef[1,3])

if(nrow(c.coef)>1){
   for(i in 2:nrow(c.coef)){
      pair.type <- ifelse((t0 ==c.coef[i,1] & t1 ==c.coef[i,2] & t2 ==c.coef[i,3]), i, pair.type)
    }
 }

pair.type <- factor(pair.type,levels=1:nrow(c.coef),labels=apply(c.coef,1,paste,collapse=","))

# after previous operations, per1&2 changes to factor in R
# so put the identity function I() in the data.frame call
dat <- data.frame(ped,I(per1),I(per2),pair.type,
                  prior0, prior1, prior2, post0, post1, post2)

attr(dat,"names") <- c("ped","per1","per2","pair.type","prior0","prior1",
                       "prior2","post0","post1","post2")

if(!(exists("is.R") && is.function(is.R) && is.R())) oldClass(dat) <- c("ibd.df")

# this is the error I fixed
#Error in as.data.frame.default(ibd.dat) : can't coerce class "ibd.df" into a data.frame

return(dat)

}
