#$Author: sinnwell $
#$Date: 2005/01/13 15:57:57 $
#$Header: /people/biostat3/sinnwell/Projects/arp.gee/Make/RCS/derivC2lambda.q,v 1.1 2005/01/13 15:57:57 sinnwell Exp $
#$Locker:  $
#$Log: derivC2lambda.q,v $
#Revision 1.1  2005/01/13 15:57:57  sinnwell
#Initial revision
#
#Revision 1.1  2004/10/07 21:51:18  sinnwell
#Initial revision
#
derivC2lambda <- function(type, c){
 switch(type,
  { # full sibs 
      deriv <- 2/(1-2*c)^2
  },

  {  #half-sibs
      deriv <- 2/(1-2*c) + 2*(1+2*c)/(1-2*c)^2
  },

  { # first cousins
      deriv <- 12/(3-4*c) + 4*(12*c+3)/(3-4*c)^2
  },

  { # grandparent - grandchild
      deriv <- 2/(1-2*c) + 2*(1+2*c)/(1-2*c)^2
   },

  { #uncle-nephew
     deriv <- 2/(1-2*c) + 2*(1+2*c)/(1-2*c)^2
   }
 )

  return(deriv)
}


