\name{read.objects}
\alias{read.objects}
\title{
  Read an s-tagged file and create an oldClass object
}
\description{
Read an external text file with S 'tags' to create a list, and then
convert the list to the appropriate oldClass, determined by the tag "s.class".
}
\usage{
read.objects(file)
}
\arguments{
\item{file}{
Character string of an external file name.
}
}
\value{
If the tag 's.class' is in the external file, then the returned object is the
oldClass defined by the 'name' following s.class (e.g., "s.class myclass"
creates an object with class 'myclass'), otherwise the returned object is a list.
}
\section{Side Effects}{

}
\details{
The external text file can contain three types of tags: s.class,
s.vector, and s.matrix. The syntax provides S-PLUS with information on
how to create a list, with items that can be vectors and matrices, and
then (if desired) convert this list to a user-defined oldClass. The
syntax for these tags is provided below (note that in the text file,
the colons ":" should not appear; they only appear in this help
documentation to separate sytax from definitions).
}
\section{S.class name}{
name is a character string that defines the class to be created within S-PLUS.
}
\section{S.vector name n v[1] v[2] ...}{
name is a character string that names the vector; n is the length of
the vector;  v[1] v[2] ... are the items of the vector.
}
\section{S.matrix name nr nc col[1] col[2] ...}{
name is a character string that names the matrix; nr the number of
rows in the matrix; nc the number of columns in the matrix; col[1]
col[2] ... the column labels. After this line of text follows nr rows
of data that are used to fill the matrix (each row must have nc columns).
}
\seealso{
finish.objects, finish.objects.default, finish.objects.genehunter
}
\examples{
}
\keyword{}
% docclass is function
% Converted by Sd2Rd version 1.21.
