\name{plot.arp.ibd}
\alias{plot.arp.ibd}
\title{
  Plot results of an arp.ibd object.
}
\description{
Plot fitted IBD allele sharing values for affected relative pairs. If
'...' includes an object of the ibd.share class, the observed average
IBD sharing values will be plotted as dashed lines.
}
\usage{
plot.arp.ibd(x, ...)
}
\arguments{
\item{x}{
An object with class arp.ibd  
}
\item{\dots }{
Extra plot parameters.  This allows an object of ibd.share class to be
passed to the function.
}
}
\value{
}
\section{Side Effects}{

}
\details{
Plots for different relative pair types are stacked vertically in the
plot area, which allows for easy comparison of different type of ARPs.
}
\section{References}{

}
\seealso{
\code{\link{arp.ibd}},
\code{\link{plot.ibd.share}}
}
\examples{
setupData(example.share)

fit.c <- arp.ibd(example.share, model="C")

plot(fit.c)
plot(fit.c, example.share)
}
\keyword{}
% docclass is function
% Converted by Sd2Rd version 1.21.
