\name{get.genehunter.ibd}
\alias{get.genehunter.ibd}
\title{
  Compute IBD matrices by Genehunter and read into S
}
\description{
Genehunter is used to compute the IBD sharing probability matrices,
and the results are read into S, and converted to a class of type
"ibd.df", an ibd data frame.
}
\usage{
get.genehunter.ibd(file.pre, file.par, mapfun="kosambi", file.ibd=NULL)
}
\arguments{
\item{file.pre }{
A pedgiree file in the LINKAGE format, prior to use of makeped
(containing ped ID, person ID, father ID, mother ID, sex, affection
status, liability class (optional), and pairs of columns for genetic markers.
}
\item{file.par }{
A data file in the LINKAGE format (containing genetic map, penetrance,
allele frequencies, etc.).
}
\item{mapfun}{
Map function used by Genehunter. The default is "kosambi", and
"haldane" is the other option. Because partial matching is used, the
user need only specify mapfun to the minimum number of unique
characters ("k" for kosambi and "h" for haldane).
}
\item{file.ibd }{
The name of the file for saving Genehunter ibd probabilities. If missing
as an argument, no file is saved.
}
}
\value{
An object of class "ibd.df". This is a data frame, with the number of
rows the number of pairs of relatives. However, the matrices for IBD
probabilities are inserted as matrices (via model.matrix), so that all
columns of an IBD matrix stay together. The items in this data frame are:

\item{ped}{
pedigree ID
}
\item{per1}{
person ID for one person of the pair
}
\item{per2}{
person ID for other person of the pair
}
\item{pair.type}{
a factor describing the type of pair, according to the prior
probabilities of linkage. The label for a pair type is "prior0,
prior1, prior2", the three sharing probabilities. This factor can be
used to subset according to type of pair (e.g., df[df\$pair.type=1,]),
and table(pair.type) gives a count of the number of different types of
relative pairs.
}
\item{prior0, prior1, prior2}{
matrices of the prior probabilities that the pairs share 0, 1, or 2
alleles IBD.
}
\item{post0, post1, post2}{
matrices of the posterior probabilities that the pairs share 0, 1, or 2
alleles IBD, given the genetic marker data.
}
}
\section{Side Effects}{

}
\details{
The function removes any old files existing in the directory, dumps a file that is used to direct the steps of
Genehunter analyses, runs Genehunter by batch,  calls a Perl script that parses the output from
Genehunter into a format that can be easily read into S-PLUS, and then
calls get.object (a general purpose routine that reads in special
tagged files, and uses a finising function to complete the formating
of input).
}
\section{References}{

}
\seealso{
get.object
}
\examples{
# the general usage is as follows
# myIBD <- get.genehunter.ibd("myFile.pre", "myFile.par",mapfun="kos")
}
\keyword{}
% docclass is function
% Converted by Sd2Rd version 1.21.
