\name{arp.ibd}
\alias{arp.ibd}
\title{
  Estimate the trait locus position simultaneously with trait locus effects 
for Affected Relative Pairs
}
\description{
Use the elements of an ibd.share object to estimate trait locus
position and its effects, allowing different types of affected
relative pairs (ARPs).
}
\usage{
arp.ibd(ibd.obj, model="C", top.pct=.4, end.cut=10, near.rng=10, tau.init=NA,
        c.init=NA, lambda.init=NA, ci.prob=0.95, max.iter=50,
        tol=0.0001, eps=1, print.iter=FALSE)
}
\arguments{
\item{ibd.obj }{
An object of the 'ibd.share' class, a list which contains the
following elements: \$smat - a matrix having estimated number of alleles shared
for affected relative pairs (rows) at each position (columns) of a 
chromosomal region; \$type - vector of affected relative pair types;
\$ped - vector of pedigree id's; and \$pos - vector of chromosome positions (in
centimorgans) matching the columns of \$smat.
}
\item{model}{
Character string with either 'C' for C-coefficients or 'Lambda', which
constrains all C's to be a function of a single lambda.
}
\item{top.pct }{
In selecting tau starting values, only consider the
positions whose mean allele sharing is in the top.pct*100 percent
}
\item{end.cut }{
Do not select a tau starting value within end.cut centimorgans from
the end
}
\item{near.rng}{
The minimum range, in centimorgans, that a separate IBD sharing peak
may be detected.  All clusters of IBD sharing peaks consecutively within
near.rng cM of each other, will provide one starting value for tau. 
}
\item{tau.init }{
Chromosome position initial value.  If none is given, the candidate
positions will be chosen based on ibd values
}
\item{c.init }{
Vector of C-coefficients, one for each ARP type.  If c.init=NA,
each element is estimated from the ibd sharing data for the relevant
ARP type by setting tau=tau.init and using least squares.
}
\item{lambda.init }{
Initial value for lambda parameter under model='Lambda'.  If not
given, then the C's are initialized as described under c.init; 
these are transformed into lambdas, and the weighted average
of these is used as the initial value.
}
\item{ci.prob }{
Probability level for constructing confidence intervals for the
parameters.
}
\item{max.iter }{
Maximum iterations allowed in Newton-Raphson steps
}
\item{tol}{
Convergence tolerance for changes in scores and parameters from previous iteration
}
\item{eps}{
Epsilon, smoothing adjustment constant from Liang et al.(2001), as
used for adjustment within the Haldane mapping function.  
}
\item{print.iter }{
Logical, if TRUE, causes print of u-scores, gamma, and info-mat after
each Newton-Raphson iteration.
}
}
\value{
An object with class arp.ibd containing the following components:

\item{var}{
Variance matrix of the parameter estimates
}
\item{lambda}{
If model='C', a table of the translated C's to lambdas
}
\item{tbl}{
Table of estimated parameters with confidence intervals
}
\item{summary.df}{
Results for each tau.init starting value, including final tau
estimate, C/lambda estimates, and gof statistic
}
\item{type}{
The unique ARP types in the dataset. 1=FS (Full-Sibs), 2=HS
(Half-Sibs), 3=FC (First-Cousins), 4=GP (GrandParent-Child), 5=AV
(AVuncular pair, i.e. uncle-nephew)
}
\item{n.type}{
Vector of counts per ARP type
}
\item{n.pair}{
Total number of relative pairs
}
\item{pos}{
Vector of chromosome positions, in centimorgans
}
\item{iter}{
Number of Newton-Raphson iterations completed 
}
\item{u.scores}{
Vector of final score values
}
\item{gamma}{
Vector of final parameter estimates: tau is the first element,
followed by either C's or lambda
}
\item{rank}{
Rank of variance matrix
}
\item{converge}{
Convergence status of the Newton-Raphson steps. 1 if converged;  
 -2 if either C or lambda estimates are out of range; -1 if tau is out
 of range, 0 if iter=max.iter without convergence.
}
\item{alias}{
Vector the same length as gamma, with elements of 1 if that element of
gamma is aliased, 0 otherwise.  Aliased parameters are not estimable
because they are 'aliased' (i.e., correlation close to one) with
another parameter.
}
\item{info.robust}{
Robust information matrix
}
\item{info}{
Last 'working' information matrix, as described in Schaid et al.(2004).  
}
\item{}{
The following elements of the arp.ibd object are unchanged from input
values: max.iter, eps, ci.prob, and model.
}
}
\section{Side Effects}{

}
\details{
Liang et al. [2001] proposed a multipoint method for simultaneously
estimating trait-locus position and the genetic effect of a
susceptibility locus when analyzing affected sib pairs. The methods in
this package extend the estimation to allow for different types of
affected relative pairs.  The 'C' model allows unconstrained
estimation of a separate C-coefficient for each ARP type.  These
coefficients represent the expected departure from random sharing at
the trait-locus.  Under the 'lambda' model, the C's are constrained to
be a function of a single parameter, lambda. Lambda represents the
ratio of risk for a relative who shares one trait allele IBD with an
affected person to the risk for a relative who shares no alleles IBD.
}
\section{References}{
Liang K-Y, Chiu Y-F, Beaty, TH (2001).  A robust identity-by-descent
procedure using affected sib pairs:  Multipoint mapping for complex
diseases.  Hum Hered 51:64-78.

Schaid DJ, Sinnwell JP, Thibodeau SN (2005). Robust Multipoint
Identical-by-Descent Mapping for Affected Relative Pairs. Am
J Hum Genet 76:128-138
}
\seealso{
\code{\link{print.arp.ibd}},
\code{\link{summary.arp.ibd}},
\code{\link{plot.arp.ibd}},
\code{\link{arp.ibd.fitter}},
\code{\link{c.ls}}
}
\examples{
setupData(example.share)

# Fit the model-C, using defaults for optional parameters. 
fit.c <- arp.ibd(example.share, model="C") 
print(fit.c)

# Fit the model-Lambda, using defaults for optional parameters
fit.lambda <- arp.ibd(example.share, model="lambda") 
print(fit.lambda)

# plot the fitted values from fit.c, compare against mean 
# ibd sharing values from example.share 
# plot(fit.c, example.share)

# plot the same for fit.lambda
# plot(fit.lambda, example.share)
}
\keyword{}
% docclass is function
% Converted by Sd2Rd version 1.21.
