#$Author: sinnwell $
#$Date: 2005/01/06 21:29:21 $
#$Header: /people/biostat3/sinnwell/Projects/arp.gee/Make/RCS/plot.arp.ibd.q,v 1.2 2005/01/06 21:29:21 sinnwell Exp $
#$Locker:  $
#$Log: plot.arp.ibd.q,v $
#Revision 1.2  2005/01/06 21:29:21  sinnwell
#shorten title statements, for fitting into LaTeX manual
#
#Revision 1.1  2004/10/07 21:53:27  sinnwell
#Initial revision
#
# Sinnwell, JP  Schaid, DJ
# Dept of Biostatistics
# Mayo Clinic, Rochester MN


plot.arp.ibd <- function(x, ... )
  
# plot the allele sharing fitted values from position and the gee equation
# parameter estimates 
# If an ibd.share object is passed in '...', extract it and plot the observed
# sharing stats in dashed lines.

{

  # get names of element in '...' from names or the deparsed version of it.
  dots <- as.list(substitute(list(...)))[-1]
  nm <- names(dots)
  fixup <- if(is.null(nm)) seq(along=dots) else nm==""
  dep <- sapply(dots[fixup], function(x) deparse(x)[1])
  if(is.null(nm)) nm <- dep else nm[fixup] <- dep

  # find the element, if any, of '...' that has class 'ibd.share'
  share.obj <- NULL
  has.share <- FALSE
  if(length(nm)) {
    for(k in 1:length(nm)) {
      tmp.obj <- if(exists(nm[k])) get(nm[k]) else NULL
      if(class(tmp.obj)=="ibd.share") {
        share.obj <- tmp.obj
        has.share <- TRUE
      }
    }
  }

  n.type <- x$n.type
  pos <- x$pos
  tau <- x$gamma[1]
  len.type <- length(n.type)
  
  par(mfrow=c(len.type, 1))
  y.obs <- numeric(0)

  for(i in 1:len.type) {
    # extract c's from gamma or convert lambda to c[i] under type[i]
    coef <- if(x$model=="C") x$gamma[i+1] else lambda2c(x$type[i], x$gamma[2])
    y.fit <- arp.fit(x$type[i], pos, tau, c.coef=coef, eps=x$eps)

    if(has.share) {
      y.obs <- apply(share.obj$smat[share.obj$type==x$type[i],], 2, mean)
    }
    y.rng <- range(c(y.fit$s.fit, y.obs))
    plot(pos, y.fit$s.fit, type="l", ylim=y.rng, ylab="Sharing", xlab="Position")#, ...)
    if(has.share) {
      lines(pos, y.obs, lty=3)
      title(paste("Fitted (solid) and Observed (dashed) IBD sharing, ARP=", as.character(x$type[i])))

    } else {
      title(paste("Fitted IBD sharing for ARP type=", as.character(x$type[i])))
    }
  }
  
  invisible(x)
}
