#$Author: sinnwell $
#$Date: 2004/10/07 21:52:32 $
#$Header: /people/biostat3/sinnwell/Projects/arp.gee/Make/RCS/lambda2c.q,v 1.1 2004/10/07 21:52:32 sinnwell Exp $
#$Locker:  $
#$Log: lambda2c.q,v $
#Revision 1.1  2004/10/07 21:52:32  sinnwell
#Initial revision
#
lambda2c <- function(type, lambda){
  # convert lambda to c, switch on type
switch(type,
  { # full sibs 
      c <- (lambda - 1)/(2*lambda)
  },

  {  #half-sibs
      c  <- (lambda - 1)/(2*(lambda + 1))
  },

  { # first cousins
      c <- 3*(lambda - 1)/(4*(lambda + 3))
  },

  { # grandparent - grandchild
      c  <- (lambda - 1)/(2*(lambda + 1))
   },

  { #uncle-nephew
      c  <- (lambda - 1)/(2*(lambda + 1))
   }
 )

  return(c)
}
