#$Author: sinnwell $
#$Date: 2005/07/05 20:39:37 $
#$Header: /people/biostat3/sinnwell/Projects/arp.gee/Make/RCS/ibd.share.merlin.q,v 1.4 2005/07/05 20:39:37 sinnwell Exp $
#$Locker:  $
#$Log: ibd.share.merlin.q,v $
#Revision 1.4  2005/07/05 20:39:37  sinnwell
#names of ibd.dat are FAMILY ID1 ID2 , new names from merlin
#
#Revision 1.3  2005/01/31 15:25:04  sinnwell
#merge.ibd.covaar to mergeIbdCovar
#
#Revision 1.2  2005/01/13 20:22:20  sinnwell
#T to TRUE
#
#Revision 1.1  2004/10/07 22:14:13  sinnwell
#Initial revision
#
ibd.share.merlin <- function(ibd.file, pre.file, min.pairs=20){

# load merlin ibd object
ibd.dat <- read.table(ibd.file, header=TRUE)
names(ibd.dat) <- c("FAMILY","ID1","ID2","MARKER","P0","P1","P2")

ibd.obj <- ibd.df.merlin(ibd.dat)

# load pre makeped linkage file to get pedigree structure and affection status
ped.dat <- read.table(pre.file)
ped.dat <- ped.dat[,1:6]
names(ped.dat)[1:6] <- c("ped","per","father","mother","sex","affection")

# merge ibd object with pre file
df <- mergeIbdCovar(ibd.obj, ped.dat)

# remove pairs of person with self
zed <- df$ID1 != df$ID2
df <- df[zed,]

# subset to pairs with both affected
zed <- df$affection.1==2 & df$affection.2==2
df <- df[zed,]

# check types of ARPs
ord <- order(df$ped)
df <- df[ord,]
arp.type <- NULL
for(i in 1:nrow(df)){
  ped.test <-  df$FAMILY[i]
  per1.test <- df$ID1[i]
  per2.test <- df$ID22[i]

  zed <- ped.dat[,1]==ped.test
  arp.type <- c(arp.type, relpair.type(ped.dat[zed,],as.numeric(per1.test), as.numeric(per2.test)))
}


df <- cbind(df, arp.type=arp.type)

# remove ARPs that are not handled by arp.gee

zed <- ifelse(df$arp.type=="FS" | df$arp.type=="HS" | df$arp.type=="GP" |
              df$arp.type=="FC" | df$arp.type=="AV", T, F)

df <- df[zed,]


# subset to ARP types that have counts of at least min.pairs

tbl <- table(df$arp.type)
utype <- names(tbl)

ord <- order(df$arp.type)
df <- df[ord,]

zed <- NULL
for(i in 1:length(utype)){
  if(tbl[i] >= min.pairs){
     keep <- rep(T, tbl[i])
  } else {
      keep <- rep(F, tbl[i])
  }
 zed <- c(zed,keep)

}    

df <- df[zed,]

# order df by arp type
ord <- order(df$arp.type)
df <- df[ord,]

# setup for ibd.share class

smat <- 2 * df$P2 + df$P1
type <- df$arp.type
ped  <- df$FAMILY
upos <- as.numeric(dimnames(df$P2)[[2]])
per1 <- df$ID1
per2 <- df$ID2

# create factor for ARP type, and order by integer code of this factor
type.factor <- factor(type, levels=c("FS","HS","FC","GP","AV"), exclude="NA")
type.code <- as.numeric(type.factor)
ord <- order(type.code)
smat <- smat[ord,]
type.factor <- type.factor[ord]
ped <- ped[ord]
per1 <- per1[ord]
per2 <- per2[ord]

ibd.dat<- list(smat=smat, ped=ped, per1=per1, per2=per2, type=type.factor, pos=upos)
oldClass(ibd.dat) <- "ibd.share"

return(ibd.dat)

}
