#$Author: sinnwell $
#$Date: 2005/01/31 15:24:51 $
#$Header: /people/biostat3/sinnwell/Projects/arp.gee/Make/RCS/ibd.share.genehunter.q,v 1.4 2005/01/31 15:24:51 sinnwell Exp $
#$Locker:  $
#$Log: ibd.share.genehunter.q,v $
#Revision 1.4  2005/01/31 15:24:51  sinnwell
#merge.ibd.covar to mergeIbdCovar
#
#Revision 1.3  2004/12/29 19:50:40  sinnwell
#remove quote around 'NA' in factor, causes warning in R.
#
#Revision 1.2  2004/10/07 23:34:07  schaid
#added per1 and per2, and ordered by type integer code
#
#Revision 1.1  2004/10/07 21:52:06  sinnwell
#Initial revision
#
ibd.share.genehunter <- function(ibd.file, pre.file, min.pairs=20){

  ibd.obj <- get.object(file=ibd.file,parse.genehunter.ibd.pl)

# load pre makeped linkage file to get pedigree structure and affection status
  ped.dat <- read.table(pre.file)
  ped.dat <- ped.dat[,1:6]
  names(ped.dat)[1:6] <- c("ped","per","father","mother","sex","affection")

# merge ibd object with pre file
  df <- mergeIbdCovar(ibd.obj, ped.dat)

# subset to pairs with both affected
  zed <- df$affection.1==2 & df$affection.2==2
  df <- df[zed,]

# remove parent-offspring pairs

  po <- df$pair.type=="0,1,0"
  df <- df[!po,]

# check types of ARPs
  ord <- order(df$ped)
  df <- df[ord,]
  arp.type <- NULL
  for(i in 1:nrow(df)){
    ped.test <-  df$ped[i]
    per1.test <- df$per1[i]
    per2.test <- df$per2[i]

    zed <- ped.dat[,1]==ped.test
    arp.type <- c(arp.type, relpair.type(ped.dat[zed,],as.numeric(per1.test), as.numeric(per2.test)))
  }

# compare computed type verus prior ibd sharing type
  df <- cbind(df, arp.type=arp.type)

# remove ARPs that are not handled by arp.ibd

  ck1 <- ifelse(df$pair.type=="0.25,0.5,0.25" | df$pair.type=="0.5,0.5,0" | 
                df$pair.type=="0.75,0.25,0",T,F)
  ck2 <- ifelse(df$arp.type=="FS" | df$arp.type=="HS" | df$arp.type=="GP" |
                df$arp.type=="FC" | df$arp.type=="AV", T, F)
  zed <- ck1 & ck2

  df <- df[zed,]

# subset to ARP types that have counts of at least min.pairs

  tbl <- table(df$arp.type)
  utype <- names(tbl)
  
  ord <- order(df$arp.type)
  df <- df[ord,]

  zed <- NULL
  for(i in 1:length(utype)){
    if(tbl[i] >= min.pairs){
      keep <- rep(T, tbl[i])
    } else {
      keep <- rep(F, tbl[i])
    }
    zed <- c(zed,keep)
    
  }    
  
  df <- df[zed,]

# order df by arp type
  ord <- order(df$arp.type)
  df <- df[ord,]

# setup for ibd.share class
  smat <- 2 * df$post2 + df$post1
  type <- df$arp.type
  ped  <- df$ped
  upos <- as.numeric(dimnames(df$post2)[[2]])
  per1 <- df$per1
  per2 <- df$per2

# create factor for ARP type, and order by integer code of this factor
  type.factor <- factor(type, levels=c("FS","HS","FC","GP","AV"), exclude=NA)
  type.code <- as.numeric(type.factor)
  ord <- order(type.code)
  smat <- smat[ord,]
  type.factor <- type.factor[ord]
  ped <- ped[ord]
  per1 <- per1[ord]
  per2 <- per2[ord]
  
  ibd.dat<- list(smat=smat, ped=ped, per1=per1, per2=per2, type=type.factor, pos=upos)
  oldClass(ibd.dat) <- "ibd.share"
  
  return(ibd.dat)

}
