#$Author: sinnwell $
#$Date: 2005/01/13 20:30:45 $ 
#$Header: /people/biostat3/sinnwell/Projects/arp.gee/Make/RCS/finish.objects.genehunter.ibd.q,v 1.6 2005/01/13 20:30:45 sinnwell Exp $
#$Locker:  $
#$Log: finish.objects.genehunter.ibd.q,v $
#Revision 1.6  2005/01/13 20:30:45  sinnwell
#F to FALSE
#
#Revision 1.5  2004/08/03 20:54:07  sinnwell
#use I() to preserve char vectors in R/S
#
#Revision 1.4  2003/01/18 19:20:19  schaid
#added stringsAsFactors=FALSE to data.frame to keep id's as character
#
#Revision 1.3  2003/01/17 14:47:18  schaid
#forced per1 and per1 id's to be character, to avoid them being treated as factors on some systems.
#
#Revision 1.2  2003/01/15 16:28:38  schaid
#*** empty log message ***
#
finish.objects.genehunter.ibd <- function(obj){

# Title: Method to finish obj of class genehunter.ibd, as read by read.objects
 
   # No need for s.class, once we finish the class defininitions
   obj$s.class <- NULL

   #ibd data frame

   ibd.col.names <- dimnames(obj$ibd)[[2]]
   x<-obj$ibd
   nr <- nrow(x)

   # treat id's different from other col's: id's are character, other
   # cols are numeric

   ped  <- as.character(x[,1])
   per1 <- as.character(x[,3])
   per2 <- as.character(x[,4])

   x <- x[,-c(1,3,4)]
   x <- as.numeric(x)
   x <- matrix(x,nrow=nr,byrow=FALSE)
   dimnames(x)[[2]] <- ibd.col.names[-c(1,3,4)]
   
   # preserve char vectors when put in data.frame with I()
   df <- data.frame(I(ped),I(per1),I(per2),x)

   ibd <- ibd.df(df)

   return(ibd)
}
