#$Author: sinnwell $
#$Date: 2004/10/07 21:50:57 $
#$Header: /people/biostat3/sinnwell/Projects/arp.gee/Make/RCS/c.ls.q,v 1.1 2004/10/07 21:50:57 sinnwell Exp $
#$Locker:  $
#$Log: c.ls.q,v $
#Revision 1.1  2004/10/07 21:50:57  sinnwell
#Initial revision
#

c.ls <- function(type, smat, pos, tau, eps) {

#  utype <- length(utype)
#  c.init <- numeric(nutype)
#  for(i in 1:nutype){
#    c.init[i] <-  c.ls(type=utype[i], ch20.ibd$smat[ch20.ibd$type==utype[i],], ch20.ibd$pos, tau=70, eps=1)
#  }
  
  dist  <-  pos - tau;

  delta <- ifelse(abs(dist) <= eps,(dist*dist)/(2.0*eps) + eps/2.0, abs(dist))
 
  switch(type,
    { #full sibs
      a <- 1.0;
      x <- exp(-.04 * delta);
    },
    { # half-sibs
      a <- 0.5;
      x <- exp(-.04 * delta);
    },
     { #first cousins
      a <- 0.25;
      x <- 0.5*exp(-.04*delta) + 0.33333*exp(-.06*delta) + 0.16666*exp(-.08*delta);
    },
   { # grandparent - grandchild
      a  <-  0.5;
      x  <-  exp(-.02*delta);
    },
   { # uncle-nephew
      a  <-  0.5;
      x  <-  0.5*exp(-.04*delta) + 0.5*exp(-.06*delta);
   }
 )

  npair <- nrow(smat)
  npos <- ncol(smat)
  svec <- as.vector(t(smat))
  x <- rep(x, npair)

  y <- (svec - a) 
  beta <- sum(x*y) / sum(x*x)

  return(beta)

}
