% $Author: sinnwell $
% $Date: 2008/01/04 22:14:52 $
% $Header: /people/biostat3/sinnwell/genet/rpack/Armitage/RCS/armitage.Rd,v 1.1 2008/01/04 22:14:52 sinnwell Exp $
% $Locker:  $ 
% $Log:

\name{armitage}
\alias{armitage}
\title{
  Armitage trend statistics for matrix of predictors with trait
}
\description{
Compute Armitage trend chi-square statistics to evaluate the
association of a trait with predictors given a dose vector of length 3
(for scoring genotype dosages).
}
\usage{
armitage(status, genoMatrix, snpLabels=NULL, dose=0:2, nsim=0, seed=NULL)
}
\arguments{
\item{status}{
Vector of non-missing values describing subject status coded as 0 for controls, 1 for cases.
}
\item{genoMatrix}{
Matrix of genotypes, such that each locus has a single allele count
vector coded 0,1,2 and NA for missing.  If there are K loci, then
ncol(genoMatrix)=K.  Rows represent allele counts for each subject.
}
\item{snpLabels}{
Vector of labels for loci, of length K (see definition of genoMatrix).
}
\item{dose}{
The "effect" pattern of alleles on the response.  The default dose is
the vector c(0,1,2) which assumes an additive effect.
}
\item{nsim}{
The number of simulations to run.  
}
\item{seed}{
An integer or a saved copy of .Random.seed.  This allows simulations
to be reproduced by using the same initial seed.
}
}
\value{
An object of class armitage which is a list with the following
components:

\item{nsubj}{
Number of cases and controls
}
\item{ngeno}{
Number of markers analyzed
}
\item{dose}{
The dose vector
}
\item{seed}{
The random seed used for simulations
}
\item{nsim}{
The number of simulations performed
}
\item{statObs}{
A vector of observed chi square statistics.  Length is equal to ngeno.
}
\item{statSim}{
Matrix of simulated statistics. Each row of statSim contains
statistics for all markers for a single simulation.  Dimensions are
nsim*ngeno.
}
\item{snpLabels}{
Vector of loci labels.
}
}
\details{
Compute Armitage trend statistics for each marker using a specified
dose vector. Simulations are performed by randomly permuting
case-control status and recalculating statistics for all markers.  A
summary method (summary.armitage) calculates multiple comparison
adjusted p-values using the method described by Westfall. 
}
\section{References}{
Sasieni PD (1997). From Genotypes to Genes: Doubling the Sample Size
}
\seealso{
\code{\link{print.armitage}},
\code{\link{armitage.concat}},
\code{\link{summary.armitage}},
}
\examples{
setupData(seqhap.dat)
y <- seqhap.dat[,1]
geno <- seqhap.dat[,-1]
##  There are no missing genotypes
table(as.matrix(geno))
##  Convert to single allele count var for each marker
gmat <- geno2to1(geno)

arm.fit <- armitage(y, gmat, snpLabels=dimnames(gmat)[[2]], dose=0:2, nsim=100)
print(arm.fit)
summary(arm.fit)
}
\keyword{}
% docclass is function
% Converted by Sd2Rd version 37351.
