\name{arrayStress}
\alias{arrayStress}

\title{
This function is used to calculate the amount of stress an array
undergoes during the normalization process by comparing the pre- and
post-normalized data
}
\description{
This function is used to calculate the amount of stress an array
undergoes during the normalization process by comparing the pre- and
post-normalized data. The median absolute deviation (MAD) for an array
is calculated as median( |yraw-ynorm-C| ) where the median is across all
the features/probes of the array. Since we are not concerned about
arrays which deviate by a constant shift, C=mean(yraw-ynorm) is used to
center the stress metric.
}
\usage{
arrayStress(yraw, ynorm)
}

\arguments{
  \item{yraw}{
Unnormalized intensity matrix (rows are features, columns are samples)
}
  \item{ynorm}{
Normalized intensity matrix (rows are features, columns are samples)
}
}
\details{
It is entirely left to the user to specify the normalization routine
used outside of the functions provided here. This function simply
requires the pre- and post-normalized data.
}
\value{

}
\references{

}
\author{
Douglas W. Mahoney
}
\note{

}


\seealso{

}
\examples{

#arrayStress(ynorm=normalized,yraw=chow.etal)

}

\keyword{ Stress }
