dfArray <-
function(ynorm,robust=TRUE,verbose=FALSE,use.target=NA) {

  dfarray <- matrix(NA,nrow=nrow(ynorm),ncol=ncol(ynorm))  
  
  ##Calculate dfarray using leave on out
  
  if(robust==F) {

    if (is.na(use.target)) {
      
      if (verbose) message("Calculating dfarry No Target \n")
      
      nr <- nrow(ynorm)
      nc <- ncol(ynorm)-1
      
      ynormi <- rep(NA,nr)
      si <- rep(NA,nr)
      
      for (i in 1:ncol(ynorm)) {

        ynormi <- rowMeans(ynorm[,-i],na.rm=TRUE)
        si <- sqrt(apply(ynorm[,-i],1,var,na.rm=TRUE))
       
        if (verbose) message(paste("array", i ,"\n",sep=" "))
        
      }

      ##For dead probes across arrays we will floor the estimate
      ##to be no smaller than the 10th percentile
    
      si <- ifelse(si<quantile(si,p=0.1,na.rm=TRUE),quantile(si,p=0.1,na.rm=TRUE),si)
      dfarray <- (ynorm-ynormi)/si
      
    }
    if (!is.na(use.target)) {
      
      if (verbose) message("Calculating dfarry With Target \n")
      
      nr <- nrow(ynorm)
      nc <- ncol(ynorm)-1
      
      ynormi <- ynormi <- use.target
      si <- rep(NA,nr)
      
      for (i in 1:ncol(ynorm)) {
        
        si <- sqrt(apply((ynorm[,-i]-ynormi)^2,1,sum,na.rm=TRUE)/((ncol(ynorm)-1)-1))
        
          if (verbose) message(paste("array", i ,"\n",sep=" "))
        
      }
      
      ##For dead probes across arrays we will floor the estimate
      ##to be no smaller than the 10th percentile
    
      si <- ifelse(si<quantile(si,p=0.1,na.rm=TRUE),quantile(si,p=0.1,na.rm=TRUE),si)
      dfarray <- (ynorm-ynormi)/si
      
    }
    
    
  }
  
  ##Calculate robust dfarray
  
  if (robust==TRUE) {
    
    if (is.na(use.target)) {
      
      if (verbose) message("Calculating dfarry Robust No Target \n")
      
      ynormi <- rep(NA,nrow(ynorm))
      si <- ynormi
      
      
      for (i in 1:nrow(ynorm)) {
        
        ynormi[i] <- quantile(ynorm[i,],p=.5,na.rm=TRUE)
        
        si[i] <- quantile(abs(ynorm[i,]-ynormi[i]),p=.5,na.rm=TRUE)*1.4826
        
      }
    }
    
    
    if (!is.na(use.target)) {
      
      if (verbose) message("Calculating dfarry Robust With Target \n")
      
      ynormi <- rep(NA,nrow(ynorm))
      si <- ynormi
      
      
      for (i in 1:nrow(ynorm)) {
        
        ynormi <- use.target
        
        si[i] <- quantile(abs(ynorm[i,]-ynormi[i]),p=.5,na.rm=TRUE)*1.4826
        
      }
    }
    
    
    ##For dead probes across arrays we will floor the estimate
    ##to be no smaller than the 10th percentile
    
    si <- ifelse(si<quantile(si,p=0.1,na.rm=TRUE),quantile(si,p=0.1,na.rm=TRUE),si)
    
    dfarray <- (ynorm-ynormi)/si
    
  }
  
  
  return(dfarray)
  
}
