\name{plot.dfArray}
\alias{plot.dfArray}

\title{
Either a density curve or mean profile plot of dfArray
}
\description{
This function is used to generate density curves or a mean profile plot for
quality assessment purposes. If arrays follow a similar underlying
distribution, then one would expect to see very little global
differences between the density curves. If not specified, Arrays are
first ordered by distributional characteristics of the object and it is
recommended that the user define a color scheme using colorRampPalette
or similar to distinguish  the different arrays. A hotwheels color
scheme is used as a default

}
\usage{
plot.dfArray(object, xvar = NULL, cols = NULL, take.abs = TRUE,
plot.type = c("density"), order.array = NULL, ...)
}

\arguments{
  \item{object}{
Is the output matrix from dfArray
}
  \item{xvar}{
User must specify the feature mean expression if the profile plot option
is choosen 
}
  \item{cols}{
With many arrays, a colorRampPalette scheme is highly recommended
}
  \item{take.abs}{
If TRUE (default), deviations above or below the median target array are
considered as equivalent errors and arrays are ordered according the thier
median |dfArray|. If F, then the actual standardized deviations above or
below the median target array are used and the arrays are ordered according to
their global shifts from the target
}
  \item{plot.type}{
Either "density" or "profile"
}
  \item{order.array}{
A unique ordering vector with length equal to the number of columns in object
}
  \item{\dots}{
    Addtional plotting parameters such as xlab, ylab, etc.
}
}
\details{

}
\value{

}
\references{

}
\author{
Douglas W. Mahoney
}
\note{

}


\seealso{

}
\examples{

##First two plots are useful to consider BUT NOT part of the function

##First pass, plot stress vs dfarray with lines indicating suggested cut offs

#plot(stress,dfarray,xlab="median Stress",ylab="median |dfArray|")
#abline(v=1.5,h=1)

##Box-plot of raw data ordered by Stress

#boxplot(as.vector(chow.etal[,order(stress)])~rep(1:57,each=nrow(chow.etal)),
#        ylim=c(0,16),xaxt="n")
#axis(3,1:ncol(chow.etal),signif(stress[order(stress)],2))
#text(1:57,rep(0,57),colnames(chow.etal),srt=90,cex=.75)
##Look at the density curves of dfArray

##First without absolute values (mean shift)

#plot.dfArray(dfArray(normalized),take.abs=FALSE,plot.type="density")

##Next take absolute value

#plot.dfArray(dfArray(normalized),take.abs=TRUE,plot.type="density")

##Profile plot as a funtion of expression
##Colors increase with higher dfArray values

#plot.dfArray(xvar=rowMeans(normalized),object=dfArray(normalized),
#take.abs=TRUE,plot.type="profile",xlab="Feature Mean",
#ylab="|dfArray|",ylim=c(0,10))


}

