plot.dfArray <-
function(object,xvar=NULL,cols=NULL,take.abs=TRUE,plot.type=c("density"),
                           order.array=NULL, ...) {

  if (!plot.type %in% c("density","profile")) {
    stop("plot type must be specified as either density or profile")
  }

  if (plot.type=="profile") {
    if (is.null(xvar)) 
    stop("Must provide the feature mean for the profile plot")
  }

  if (!is.null(xvar)) {
    if (length(xvar)!=nrow(object))
      stop("Length of feature mean must equal number of row in object")
  }
  
  if (!is.null(order.array)) {
    if (length(order.array)!=ncol(object)) {
      stop("Length of ordering vector must equal the number of columns in object")
    }
    if (length(order.array)!=length(unique(order.array))) {
      stop("Must provide unique ordering for the columns of object")
    }
    indx <- order.array
  }
  
  if (is.null(order.array)) {

    if (take.abs==TRUE) {
      
      indx <- order(apply(abs(object),2,FUN=quants)[2,])
    }

    if (take.abs==FALSE) {
      
      indx <- order(apply(object,2,FUN=quants)[2,])
    }
  }
  
  if (is.null(cols)) {
    
    hotwheels <- colorRampPalette(c("#00007F", "blue", "#007FFF", "cyan",
                                    "#7FFF7F", "goldenrod", "#FF7F00", "red"))
    cols <- hotwheels(ncol(object))
  }
  
  if (plot.type=="profile") {

    if (take.abs==TRUE) {
      plot(range(xvar,na.rm=TRUE),range(abs(object),na.rm=TRUE),pch=" ", ...)
      
      for (i in 1:ncol(object)) {
        
        lines(mlowess(xvar,abs(object[,indx][,i])),col=cols[i], ...)
      }
    }

    if (take.abs==FALSE) {
      plot(range(xvar,na.rm=TRUE),range(object,na.rm=TRUE),pch=" ", ...)
      
      for (i in 1:ncol(object)) {
        
        lines(mlowess(xvar,object[,indx][,i]),col=cols[i], ...)
      }
    }

  }
  
  if (plot.type=="density") {
  
    if (take.abs==TRUE) {
      object <- abs(object[,indx])
     
      tz <- rep(NA,ncol(object))
      
      for (i in 1:ncol(object)) {
        tz[i] <- max(density(object[,i],na.rm=TRUE)$y,na.rm=TRUE)
      }
      
      
      plot(range(object,na.rm=TRUE),c(0,max(tz,na.rm=TRUE)),pch=" ", ... )
      
      
      for (i in 1:ncol(object)) {
        lines(density(object[,i],na.rm=TRUE),col=cols[i])
        Axis(at=quantile(object[,i],p=.5,na.rm=TRUE),
             col.ticks=cols[i],labels=FALSE,tck=0.03,
             side=1,lwd=0,lwd.ticks=0.5)
      }
      
    }
  
    if (take.abs==FALSE) {
      object <- object[,indx]
     
      tz <- rep(NA,ncol(object))
      
      for (i in 1:ncol(object)) {
        tz[i] <- max(density(object[,i],na.rm=TRUE)$y,na.rm=TRUE)
      }
      
      
      plot(range(object,na.rm=TRUE),c(0,max(tz,na.rm=TRUE)),pch=" ", ... )
      
      
      for (i in 1:ncol(object)) {
        lines(density(object[,i],na.rm=TRUE),col=cols[i])
        Axis(at=quantile(object[,i],p=.5,na.rm=TRUE),
             col.ticks=cols[i],labels=FALSE,tck=0.03,
             side=1,lwd=0,lwd.ticks=0.5)
      }
      
    }
  }
    
}
