#!/usr/bin/perl

=head1 NAME
   globalLog.pl

=head1 SYNOPSIS
    USAGE: globalLog.pl -r=run_info.txt -o=output_dir

=head1 OPTIONS

B<--run_info, -r>
	Run info file

B<--output_dir, -o>
	Output directory

B<--help,-h>


=head1  DESCRIPTION
	Create global concenses warning and error log file.

=head1  INPUT

=head1  OUTPUT


=head1  CONTACT
  bjaysheel@gmail.com


==head1 EXAMPLE
	./globalLog.pl -r=run_info.txt -o=output_dir

=cut

use strict;
use warnings;
use Data::Dumper;
use Pod::Usage;
use Getopt::Long qw(:config no_ignore_case no_auto_abbrev pass_through);
use ParseConfig;
use Workflow::Logger;

my %options = ();
my $results = GetOptions (\%options,
                          'run_info|r=s',
						  'output_dir|o=s',
						  'help|h') || pod2usage();

## display documentation
if( $options{'help'} ){
    pod2usage( {-exitval => 0, -verbose => 2, -output => \*STDERR} );
}

#############################################################################
## make sure everything passed was peachy
&check_parameters(\%options);

## parse X_info files
my $config = new ParseConfig($options{run_info});

my $logger = new Workflow::Logger('LOG_FILE'=>"$config->{RunInfo}->{logs}/GlobalLog.log",
								  'LOG_LEVEL'=>$options{'debug'});
$logger = Workflow::Logger::get_logger();

$logger->info("Sampling started");

my $cmd = "";

#### check for warnings and errors
#### ignore few warning rules such as
#### e.g: Warning: Encountered reference sequence with only gaps
#### e.g: Interpreter - org.broadinstitute.sting.utils.variantcontext.VariantContextUtils.initializeMatchExps@314![0,18]: 'ReadPosRankSum > 8;' > error
my @error_ignore;
my @warn_ignore;

push (@warn_ignore, "Warning: Encountered reference sequence with only gaps");
push (@warn_ignore, "Interpreter - org.broadinstitute.sting.utils.variantcontext");

push (@error_ignore, "Interpreter - org.broadinstitute.sting.utils.variantcontext");

#### check for warnings
$cmd = "grep -wi \"warning\\|warnings\\|warn\" $options{output_dir}/logs/*";

#### setup ignore rule
foreach my $rule (@warn_ignore){
	$cmd .= " | grep -v \"$rule\"";
}

$cmd .= " > $options{output_dir}/warnings.log";
execute_cmd($cmd);


#### check for errors
$cmd = "grep -wi \"error\\|Use of uninitialized value\" $options{output_dir}/logs/*";

#### setup ignore rule
foreach my $rule (@error_ignore){
	$cmd .= " | grep -v \"$rule\"";
}

$cmd .= " > $options{output_dir}/errors.log";
execute_cmd($cmd);

exit();

#############################################################################
sub check_parameters {
    my $options = shift;

	my @required = qw(run_info output_dir);

	foreach my $key (@required) {
		unless ($options{$key}) {
			print STDERR "ARG: $key is required\n";
			pod2usage({-exitval => 2,  -message => "error message", -verbose => 1, -output => \*STDERR});
			exit(-1);
		}
	}

	$options{'beauty'} = 0 unless ($options{'beauty'});
}

#############################################################################
sub execute_cmd {
	my $cmd = shift;

	$logger->info("$cmd");
	system($cmd);

	#while (( $? >> 8 ) != 0 ){
	#	$logger->logdie("ERROR: Following command failed to execute. Exiting execution of workflow\n$cmd");
	#}
}
