package Tools::Verify::TopHat;

@ISA = qw(Tools::Verify); 

use Tools::Verify ; 
use strict ; 
use warnings ; 

use File::Basename;

sub init {
	my $self = shift ; 

	$self->{name} = 'TopHat'; 
	$self->{filename} = 'tophat'; 
	$self->{executable} = TRUE ; 
	$self->{min_version} = "2.0.6"; 
	@{$self->{run_dependencies}} = qw/Python/;
} 

sub getDescription { return "TopHat (Mayo Patched Version)"; }

sub getConfigLabel { return "TOPHAT"; }

sub getConfigType { return "dir"; }

sub getSource { return "Mayo customized version included in package. Patch details available in the MAPRSeq/patches directory"; }

sub getVersion { 
	my $self = shift ; 

	my $filename = $self->getPath(); 

	my $command = "$filename -v";
	my $output = $self->execute($command);

	my $version = undef ; 

	my @lines = split(/\n/, $output); 

	# TopHat v2.0.6
	foreach my $thisLine (@lines){ 
		chomp($thisLine); 
		if($thisLine =~ /^TopHat/){ 
			$version = $thisLine ; 
			$version =~ s/^TopHat v(\d+.\d+.\d+)/$1/ ; 
		}
	}

	return $version ; 
}

sub download { 
}

sub build { 
}

sub install { 
}

sub new { 
	my $this = shift ; 
	my $class = ref($this) || $this ; 
	my $self = {} ; 
	bless $self, $class; 
	$self->{package} = __PACKAGE__ ; 
	$self->init(); 
	return $self; 
}

1;
