package Tools::Verify::R;

@ISA = qw(Tools::Verify);

use Tools::Verify ;
use strict ;
use warnings ;


sub init {
        my $self = shift ;

        $self->{name} = 'R';
        $self->{filename} = 'R';
        $self->{executable} = TRUE ;
        $self->{min_version} = "2.14.0";
}

sub getDescription { return "R"; }

sub getConfigLabel { return "R"; }

sub getConfigType { return "dir"; }

sub getSource { return "Included in your system distribution"; }

sub getVersion {
        my $self = shift ;

        my $filename = $self->getPath();

        my $command = "$filename --version 2>&1";
        my $output = $self->execute($command);

        my $version = undef ;

        my @lines = split(/\n/, $output);

		# R version 2.14.1 (2011-12-22)
        foreach my $thisLine (@lines){
                chomp($thisLine);
                if($thisLine =~ /^R version /){
                        $version = $thisLine ;
                        $version =~ s/^R version (\d+.\d+.\d+).*/$1/ ;
                }
        }

        return $version ;
}

sub download {
}

sub build {
}

sub install {
}

sub new {
        my $this = shift ;
        my $class = ref($this) || $this ;
        my $self = {} ;
        bless $self, $class;
        $self->{package} = __PACKAGE__ ;
        $self->init();
        return $self;
}

1;
