package MyUtility;

use strict;
use warnings;
use Data::Dumper;

sub new {
    my ($class) = @_;
    my $self = {};

	$self->{contact} = "bhavsar.jaysheel\@mayo.edu";

 	bless($self,$class);

	return $self;
}

sub init {
	## initalizing
}

sub createErrorFile {
	my ($self, $file, $cmd) = @_;

	## open file and write out the command that should be executed
	## manually
	open(FHD, ">", $file) or die "Could not open file $file to write";
	print FHD $cmd."\n";
	close(FHD);

}

sub reportError {
	my ($self, $file, $cmd, $emailTo, $step, $sample, $sgeerr, $sgeout) = @_;

	my $str = "There is an error executing $step.\n";
	$str .= "\n";

	if (length($sgeerr) || length($sgeout)){
		$str .= "Please check SGE log files for sample: $sample\n";
		$str .= "          $sgeerr\n";
		$str .= "          $sgeout\n";
	}

	$str .= "\n";
	$str .= "Command executed was\n";
	$str .= "          $cmd\n";
	$str .= "\n";
	$str .= "This comand is also available in\n";
	$str .= "          $file\n";
	$str .= "\n";
	$str .= "Once you have fixed the error be sure to delete following file\n";
	$str .= "          $file\n";
	$str .= "\n";
	$str .= "If the file is not deleted workflow will not continue\n";
	$str .= "\n";
	$str .= "For futher assitance and information please contact Jaysheel Bhavsar at bhavsar.jaysheel\@mayo.edu\n";
	$str .= "\n";
	$str .= "Thank you\n";
	$str .= "Workflow team";

	system("echo \"$str\" | mailx -s \"Error in MAPRSeq workflow executing $step\" \"$emailTo\"");
}

sub missingInput {
	my ($self, $emailTo, $currentStep, $expectedErrorIn, $file, $workflow) = @_;

	my $str = "Workflow has halted execution of $currentStep.  An expected input file $file is missing or empty.\n";
	$str .= "Please check previous step $expectedErrorIn to confirm that it ran successfully and created expected output file\n";
	$str .= "$file\n\n";

	$str .= "While executing workflow [$workflow], a ${workflow}.OUTPUT_FOLDER.TIMESTAMP.log was created in the location where workflow as initated from\n";
	$str .= "Please check this file for appropriate command and parameters used to execute $expectedErrorIn\n";

	$str .= "Please contact $self->{contact} for further assitance\n";
	$str .= "Thank you";

	system("echo \"$str\" | mailx -s \"Error in $workflow workflow executing $currentStep\" \"$emailTo\"");
}

sub date {
	my @months = qw(Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec);
    my @weekDays = qw(Sun Mon Tue Wed Thu Fri Sat Sun);
    my ($second, $minute, $hour, $dayOfMonth, $month, $yearOffset, $dayOfWeek, $dayOfYear, $daylightSavings) = localtime();
    my $year = 1900 + $yearOffset;
    #my $theTime = "$hour:$minute:$second, $weekDays[$dayOfWeek] $months[$month] $dayOfMonth, $year";
    #print "Time now: " . $theTime."\n";

	return $month."/".$dayOfMonth."/".$year;
}

1;
