stdin = commandArgs()
## Input file 1: number of genes with no counts
## Input file 2: samples names
for (i in 1:1)
{
	if (length(stdin)==8)
	{
		chrvalues=as.character(stdin[6])
		chrnames=as.character(stdin[7])
		samplenames=as.character(stdin[8])
	}
}
data=read.table(file=chrvalues, header=FALSE, sep="\t")
samples=read.table(file=samplenames, header=T, sep="\t")
chrs=as.matrix(read.table(file=chrnames))
max_y=max(data)
min_y=min(data)
num=nrow(chrs)
num_sample=ncol(samples)

plot_colors <- sample(colours(),ncol(data))
# plot_colors <- c("blue","red","forestgreen","tan1","saddlebrown","plum1","navyblue","orange3")
#pdf(file="QC_ReadsDistribution.pdf", width=20, heigh=10)
png(filename="UniqueMappedReads_PerChr.png", bg="white", res=100)
plot(data[,1], type="l", col=plot_colors[1], ylim=c(min_y,max_y), lwd=1, axes=FALSE, ann=FALSE)
text(1:num, srt=45, par("usr")[3] - 2, adj=1, labels=c(chrs), xpd=T, cex=0.7)
axis(2, las=1, cex.axis=0.8)
box()
for (i in 1:num_sample)
{
	lines(data[,i], type="l", pch=22, lty=1, lwd=1, col=plot_colors[i], ylim=c(min_y,max_y))
}
title(main="Uniquely mapped reads per chromosome", col.main="red", font.main=4)
title(xlab= "Chromosomes", col.lab=rgb(0,0.5,0))
title(ylab= "Counts", col.lab=rgb(0,0.5,0))
par(xpd=TRUE)
#legend((num-5), (max_y/2), names(samples), cex=0.5, col=plot_colors, lty=1, lwd=1, bty="n")
legend("topright", names(samples), cex=0.5, col=plot_colors, lty=1, lwd=1, bty="n")
dev.off()
