#!/usr/bin/perl

=head1 NAME
   template.pl

=head1 SYNOPSIS
    USAGE: template.pl [-o1=VALUE -o2=VALUE ... -oN=VALUE]

=head1 OPTIONS

B<--option1, -o1>
	option desc

B<--options2, -o2>
	option desc

B<--optionsN, -oN>
	option desc

B<--help,-h>


=head1  DESCRIPTION
	description of what script does

=head1  INPUT
	describe input(s)

=head1  OUTPUT
	describe output(s)

=head1  CONTACT
	author and contact info


==head1 EXAMPLE
	./template.pl -o1=options1 -o2=option2 -o3=options3

=cut

use strict;
use warnings;
use Data::Dumper;
use Cwd;
use Pod::Usage;
use Getopt::Long qw(:config no_ignore_case no_auto_abbrev pass_through);
use ParseConfig;
use Workflow::Logger;

my %options = ();
my $results = GetOptions (\%options,
                          'option1|o1=s',
						  'option2|o2=s',
						  'option3|o3=s',
						  'log|l=s',
			              'debug=s',
						  'help|h') || pod2usage();

## display documentation
if( $options{'help'} ){
    pod2usage( {-exitval => 0, -verbose => 2, -output => \*STDERR} );
}

#############################################################################
## make sure everything passed was peachy
&check_parameters(\%options);

## parse X_info files
my $config = new ParseConfig($options{run_info});

my $WAIT = 5;

## set local variables
my $this;
$this->{xmx} = "6g";

my $cmd = "";

## initialize logger
my $logger = new Workflow::Logger('LOG_FILE'=>"$config->{RunInfo}->{logs}/MergeBAMs.$options{sample}.log",
								  'LOG_LEVEL'=>$options{'debug'});
$logger = Workflow::Logger::get_logger();

## log info
$logger->info("Merge BAM for $options{sample} started");


###########################################
## all logic goes here.
###########################################


## log info
$logger->info("Merge BAM for $options{sample} complete");
exit();

#############################################################################
sub check_parameters {
    my $options = shift;

	my @required = qw(option1 option2 option3);

	foreach my $key (@required) {
		unless ($options{$key}) {
			print STDERR "ARG: $key is required\n";
			pod2usage({-exitval => 2,  -message => "error message", -verbose => 1, -output => \*STDERR});
			exit(-1);
		}
	}

	$options{'debug'} = 3 unless ($options{'debug'});
}

#############################################################################
sub subroutine {
	my $options = shift;

	## subroutine logic
}

#############################################################################
sub execute_cmd {
	my $cmd = shift;

	$logger->info($cmd);

	system("$cmd");
}

#############################################################################
sub qsub_execute_cmd {
	my $cmd = shift;

	$logger->info($cmd);
	sleep $WAIT;

	system("$cmd");
}

#############################################################################
