package Tools::Verify::Workflow;

@ISA = qw(Tools::Verify);

use Tools::Verify ;
use strict ;
use warnings ;


sub init {
        my $self = shift ;

        $self->{name} = 'MAPRSeq Workflow';
        $self->{filename} = 'mrna.pl';
        $self->{executable} = TRUE ;
}

sub getDescription { return "MAPRSeq mrna.pl script"; }

sub getConfigLabel { return "WORKFLOW_PATH"; }

sub getConfigType { return "dir"; }

sub getSource { return "http://bioinformatics.mayo.edu/research/maprseq/"; }

sub getVersion { return undef ; }

sub new {
        my $this = shift ;
        my $class = ref($this) || $this ;
        my $self = {} ;
        bless $self, $class;
        $self->{package} = __PACKAGE__ ;
        $self->init();
        return $self;
}

1;
