package RunInfo;

use strict;
use warnings;
use Data::Dumper;

sub new {
    my ($class, %opts) = @_;
    my $self = {};

 	bless($self,$class);
	$self->init(\%opts);

	return $self;
}

sub init {
	my ($self, $opts) = @_;

	map { $self->{$_} = $opts->{$_} } keys %{$opts};
}

sub export {
	my ($self, $file) = @_;

	open (OUT, ">", $file) or die "Could not open file $file\n";

	foreach my $key (keys %{$self}){
		$self->{$key} =~ s/=/~/;
		print OUT uc($key) ."=". $self->{$key}. "\n";
	}

	close(OUT);
}

1;
