#!/usr/bin/perl

=head1 NAME
   sangerToillumina1.3.pl

=head1 SYNOPSIS
    USAGE: sangerToillumina1.3.pl -i=input.fastq -o=output.fastq

=head1 OPTIONS

B<--input, -i>
	Required. Input fastq file

B<--output, -o>
	Required. Output fastq file


B<--help,-h>


=head1  DESCRIPTION
	Convert Sanger Quality scores to illumina 1.3

=head1  INPUT

=head1  OUTPUT


=head1  CONTACT
  bjaysheel@gmail.com


==head1 EXAMPLE
	./sangerToillumina1.3.pl -i=input.fastq -o=output.fastq

=cut

use strict;
use warnings;
use Data::Dumper;
use Pod::Usage;
use Getopt::Long qw(:config no_ignore_case no_auto_abbrev pass_through);


my %options = ();
my $results = GetOptions (\%options,
                          'input|i=s',
						  'output|o=s',
						  'help|h') || pod2usage();

## display documentation
if( $options{'help'} ){
    pod2usage( {-exitval => 0, -verbose => 2, -output => \*STDERR} );
}

my $min = 255 ;
my $max = 0 ;

my $count = 1  ;

open(FHD, "<", $options{input}) or die "Error: Could not open input file $options{input}\n";
open(OUT, ">", $options{output}) or die "Error: Could not open output file $options{output}\n";

while(<FHD>){
    my $line = $_ ;
    if($count == 1){ print OUT $line ; $count++ ; next ; }
    if($count == 2){ print OUT $line ; $count++ ; next ; }
    if($count == 3){ print OUT $line ; $count++ ; next ;  }
    if($count == 4){ print OUT sangerToIllumina($line) ; $count = 1 ; next ; }
}

exit();

#############################################################################
sub check_parameters {
    my $options = shift;

	my @required = qw(input output);

	foreach my $key (@required) {
		unless (defined $options{$key}) {
			print STDERR "ARG: $key is required\n";
			pod2usage({-exitval => 2,  -message => "error message", -verbose => 1, -output => \*STDERR});
			exit(-1);
		}
	}
}

#############################################################################
sub sangerToIllumina {

    my $fred_scores = shift ;
    chomp($fred_scores);

    my $converted_fred_scores ;

    my $linemin = 255 ;
    my $linemax = 0 ;

    foreach my $this_score (split(//,$fred_scores)){
        my $score = ord($this_score);
        $converted_fred_scores .= chr(ord($this_score) + 31) ;
    }
    
    return $converted_fred_scores . "\n" ;
}
