package Tools::Verify::Simple;

@ISA = qw(Tools::Verify); 

our $state = undef ; 

use Tools::Verify ; 
use strict ; 
use warnings ; 


sub init {
	my $self = shift ; 

	$self->{name} = 'Simple Example Module'; 
	$self->{filename} = 'samtools';

	# places to look for the binary if it's not in the path
	$self->{search_path} = "/usr/bin:/usr/local/bin" ; 

	$self->{executable} = TRUE ; 

	$self->{execute_via} = "java -jar" ; 
	$self->{execute_via} = "python" ; 
	$self->{execute_via} = "/bin/bash" ; 

	$self->{min_version} = "0.1.18"; 
	#$self->{max_version} = undef ; 
	#@{$self->{required_versions}} = () ;
	#@{$self->{required_versions}} = undef ;

	# version examples

	# minimum version
	# $self->{min_version} = "0.1.18"; 

	# maximum version
	# $self->{max_version} = "0.1.19"; 

	# version range
	# $self->{min_version} = "0.1.17"; 
	# $self->{max_version} = "0.1.19"; 

	# version set 
	# @{$self->{required_versions}} = qw/0.1.18 0.1.19 0.1.20/;

	# packages that must be available first
	@{$self->{run_dependencies}} = qw/Samtools GCC Java Make/; 
	
	@{$self->{build_dependencies}} = qw/GCC JAVA Make/; 

	# additional steps to take processing this module
	@{$self->{steps}} = qw/download build install/; 

} 


sub getDescription { 
	return "Samtools"; 
}

sub getSource { 
	return "http://downloads.sourceforge.net/project/samtools/samtools/0.1.19/samtools-0.1.19.tar.bz2"; 
}

sub getVersion { 
	my $self = shift ; 

	my $filename = $self->getPath(); 

	my $output = `$filename 2>&1`;

	my $version = undef ; 

	my @lines = split(/\n/, $output); 

	foreach my $thisLine (@lines){ 
		chomp($thisLine); 
		if($thisLine =~ /Version/){ 
			$version = $thisLine ; 
			$version =~ s/^Version: (\d+.\d+.\d+).+/$1/ ; 
		}
	}

	return $version ; 
}

sub download { 
}

sub build { 
}

sub install { 
}

sub new { 
	my $this = shift ; 
	my $class = ref($this) || $this ; 
	my $self = {} ; 
	bless $self, $class; 
	$self->{package} = __PACKAGE__ ; 
	$self->init(); 
	return $self; 
}

1;
