#!/usr/bin/perl

=head1 NAME
   create_igv.pl

=head1 SYNOPSIS
    USAGE: create_igv.pl -r=run_info.txt -o=output_dir

=head1 OPTIONS

B<--run_info, -r>
	Run info file

B<--output_dir, -o>
	output directory


B<--help,-h>


=head1  DESCRIPTION
	Create igv session xml

=head1  INPUT

=head1  OUTPUT


=head1  CONTACT
  bjaysheel@gmail.com


==head1 EXAMPLE
	./create_igv.pl -r=run_info.pl -o=output_dir

=cut

use strict;
use warnings;
use Data::Dumper;
use Cwd;
use Pod::Usage;
use Getopt::Long qw(:config no_ignore_case no_auto_abbrev pass_through);
use ParseConfig;
use Workflow::Logger;

my %options = ();
my $results = GetOptions (\%options,
                          'run_info|r=s',
						  'output_dir|o=s',
						  'log|l=s',
			              'debug=s',
						  'help|h') || pod2usage();

## display documentation
if( $options{'help'} ){
    pod2usage( {-exitval => 0, -verbose => 2, -output => \*STDERR} );
}

#############################################################################
## make sure everything passed was peachy
&check_parameters(\%options);

## parse X_info files
my $config = new ParseConfig($options{run_info});

my $this;
my $cmd = "";

my $logger = new Workflow::Logger('LOG_FILE'=>"$config->{RunInfo}->{logs}/CreateIGV.log",
								  'LOG_LEVEL'=>$options{'debug'});
$logger = Workflow::Logger::get_logger();

$logger->info("Create IGV session xml started");

my $dest = $options{output_dir} . "/igv_session.xml";
my $tracks = "";

if ((defined $config->{ToolInfo}->{ucsc_tracks}->{value}) &&
	(length($config->{ToolInfo}->{ucsc_tracks}->{value}))) {
	$tracks = $config->{ToolInfo}->{ucsc_tracks}->{value} . "/ucsc_tracks.bed";
}


open(OUT, ">", $dest) or $logger->logdie("Can not open file $dest : $!");

print OUT qq |<?xml version="1.0" encoding="UTF-8" standalone="no"?>\n|;
print OUT qq |<Global genome="$config->{RunInfo}->{genomebuild}" locus="All" version="4">\n|;
print OUT qq |<Resources>|;

foreach my $sample (keys %{$config->{SampleInfo}}) {
	my $path="ftp://rcfisinl1-212/delivery/$config->{RunInfo}->{pi}/$config->{RunInfo}->{output_folder}/secondary/alignment/tophat_${sample}/${sample}_sorted.bam";
	my $junction="ftp://rcfisinl1-212/delivery/$config->{RunInfo}->{pi}/$config->{RunInfo}->{output_folder}/secondary/alignment/tophat_${sample}/junctions.bed";

	print OUT qq {\n\t<Resource name="${sample}_sorted.bam"};
	print OUT qq { path="$path" />};
	print OUT qq {\n\t<Resource path="$junction" />};
}

#$tracks =~ s/\/data2\/bsi/http:\/\/$config->{ToolInfo}->{http_server}->{value}/g;
#print OUT qq |\n\t<Resource path="$tracks" />|;
print OUT qq |\n</Resources>|;
print OUT qq |\n</Global>|;

$logger->info("Create IGV session xml complete");
exit();

#############################################################################
sub check_parameters {
    my $options = shift;

	my @required = qw(run_info output_dir);

	foreach my $key (@required) {
		unless ($options{$key}) {
			print STDERR "ARG: $key is required\n";
			pod2usage({-exitval => 2,  -message => "error message", -verbose => 1, -output => \*STDERR});
			exit(-1);
		}
	}

	$options{'debug'} = 3 unless ($options{'debug'});
}

#############################################################################
sub execute_cmd {
	my $cmd = shift;

	$logger->info("$cmd");
	system($cmd);

	while (( $? >> 8 ) != 0 ){
		$logger->logdie("ERROR: Following command failed to execute. Exiting execution of workflow\n$cmd");

		exit(-1);
	}
}
