package Tools::Verify::Picard;

@ISA = qw(Tools::Verify); 

use Tools::Verify ; 
use strict ; 
use warnings ; 


sub init {
	my $self = shift ; 

	$self->{name} = 'Picard'; 
	$self->{filename} = 'SortSam.jar'; 
	$self->{executable} = TRUE ; 
	$self->{execute_via} = "java" ;
	$self->{execute_via_options} = "-jar" ;

	$self->{min_version} = "1.106"; 
	@{$self->{run_dependencies}} = qw/Java/;
} 

sub getDescription { return "Picard "; }

sub getConfigLabel { return "PICARD"; }

sub getConfigType { return "dir"; }

sub getSource { return "http://downloads.sourceforge.net/project/picard/picard-tools/1.106/picard-tools-1.106.zip?r=http%3A%2F%2Fsourceforge.net%2Fprojects%2Fpicard%2Ffiles%2Fpicard-tools%2F1.106%2F&ts=1390348430&use_mirror=iweb"; }

sub getVersion { 
	my $self = shift ; 

	my $filename = $self->getPath();

	my $command = $self->getFirstMatchingFilePath($self->getExecuteVia()) . " " . $self->getExecuteViaOptions() . " $filename --version"; 
	my $output = $self->execute($command, 1);

	my $version = undef ; 

	my @lines = split(/\n/, $output); 

	foreach my $thisLine (@lines){ 
		chomp($thisLine); 
		if($thisLine =~ /^\d+/){ 
			$version = $thisLine ; 
			$version =~ s/^(\d+.\d+)\(.*\)$/$1/ ; 
		}
	}

	return $version ; 
}

sub download { 
}

sub build { 
}

sub install { 
}

sub new { 
	my $this = shift ; 
	my $class = ref($this) || $this ; 
	my $self = {} ; 
	bless $self, $class; 
	$self->{package} = __PACKAGE__ ; 
	$self->init(); 
	return $self; 
}

1;
