#!/usr/local/biotools/perl/5.14.2/bin/perl

use warnings;
use strict;

print "\nINFO - script to split exons of individual genes from a comma seperated line to new lines \n";
print "RAW paramters: @ARGV\n";
if (scalar(@ARGV) != 2)
{
	die ( "Usage: $0 \n\t [Input file] [Output file] \n" );
}

else
{
	open (LIST,"$ARGV[0]");
	open (OUT,">$ARGV[1]");
    while (my $l = <LIST>)
	{
		chomp $l;
		my ($chr,$txStart,$txEnd,$transcript,$score,$strand,$cdsStart,$cdsEnd,$color,$exonCount,$exonSizes,$exonStarts) = split('\s+',$l);
		my @e_size = split(/\,/,$exonSizes);
		my @e_start = split(/\,/,$exonStarts);
		my $id = "$transcript";
		my $length = scalar (@e_start) - 1;
		for (my $i=0;$i<=$length;$i++)
		{
			my $val=$i+1;
			my $e_start = $e_start[$i] + $txStart;
			my $e_stop=$e_size[$i] + $e_start;
			my $tag=join ("#",$chr,$e_start,$e_stop,$id);
#			print OUT "E$val\t"; print OUT "$id\t"; print OUT "$e_start[$i]\t"; print OUT "$e_stop[$i]\n";
			print OUT "$chr\t$e_start\t$e_stop\t$tag"; print OUT "#E$val\n";
		}
    }
    close LIST;
	close OUT;

}
