package ToolInfo;

use strict;
use warnings;
use Data::Dumper;

sub new {
    my ($class, %opts) = @_;
    my $self = {};

 	bless($self,$class);
	$self->init(\%opts);

	return $self;
}

sub init {
	my ($self, $options) = @_;

	foreach my $key (keys %{$options}) {
		my $obj = {};

		if (-f $options->{$key}) {
			$obj->{value} = $options->{$key};
			$obj->{type} = "file";
		} elsif (-d $options->{$key}) {
			$obj->{value} = $options->{$key};
			$obj->{value} =~ s/\/$//; ## remove trailing /
			$obj->{type} = "dir";
		} else {
			$obj->{value} = $options->{$key};
			$obj->{type} = "txt";
		}

		$self->{$key}=$obj;
	}
}

sub export {
	my ($self, $file) = @_;

	open (OUT, ">", $file) or die "Could not open file $file\n";

	foreach my $key (keys %{$self}){
		$self->{$key}->{value} =~ s/=/~/;
		print OUT uc($key) ."=". $self->{$key}->{value}. "\n";
	}

	close(OUT);
}

sub trim {
	my ($self, $str) = @_;

	$str =~ s/^\s+//;
	$str =~ s/\s+$//;

	$str;
}

1;
