package Tools::Verify::Scripture;

@ISA = qw(Tools::Verify); 

use Tools::Verify ; 
use strict ; 
use warnings ; 


sub init {
	my $self = shift ; 

	$self->{name} = 'Scripture'; 
	$self->{filename} = 'scripture.jar'; 
	$self->{executable} = TRUE ; 
	$self->{execute_via} = "java" ;
	$self->{execute_via_options} = "-jar" ;

	$self->{min_version} = "0"; 
	@{$self->{run_dependencies}} = qw/Java/;
} 

sub getDescription { return "Scripture "; }

sub getConfigLabel { return "SCRIPTURE"; }

sub getConfigType { return "file"; }

sub getSource { return "ftp://ftp.broadinstitute.org/pub/papers/lincRNA/scripture.jar"; }

sub getVersion { 
	my $self = shift ; 

	my $filename = $self->getPath();

	my $command = $self->getFirstMatchingFilePath($self->getExecuteVia()) . " " . $self->getExecuteViaOptions() . " $filename"; 
	my $output = $self->execute($command, 1);

	#my $version = undef ; 

	#my @lines = split(/\n/, $output); 

	#foreach my $thisLine (@lines){ 
	#	chomp($thisLine); 
	#	if($thisLine =~ /^\d+/){ 
	#		$version = $thisLine ; 
	#		$version =~ s/^(\d+)\(/$1/ ; 
	#	}
	#}

	#return $version ;
	return "0";
}

sub download { 
}

sub build { 
}

sub install { 
}

sub new { 
	my $this = shift ; 
	my $class = ref($this) || $this ; 
	my $self = {} ; 
	bless $self, $class; 
	$self->{package} = __PACKAGE__ ; 
	$self->init(); 
	return $self; 
}

1;
