package Tools::Verify::HTSeqLib;

@ISA = qw(Tools::Verify); 

use Tools::Verify ; 
use strict ; 
use warnings ; 

use File::Basename;

sub init {
	my $self = shift ; 

	$self->{name} = 'HTSEQ Lib'; 
	$self->{directory} = 'site-packages'; 
	$self->{executable} = FALSE ; 
	@{$self->{run_dependencies}} = qw/Python/;
} 

sub getDescription { return "HTSeq Python Lib "; }

sub getConfigLabel { return "HTSEQPATH"; }

sub getConfigType { return "dir"; }

sub getSource { return "https://pypi.python.org/packages/source/H/HTSeq/HTSeq-0.5.3p9.tar.gz"; }

sub functionTest { 
	my $self = shift ; 

	my $path = $self->getPath(); 
	if(-f $path){ $path = dirname($path); } 

    my $dir = $path . "/HTSeq";

	if(!-d $dir){ return "HTSEQ_LIB_PATH missing directory \"$dir\""; }

	return TRUE ; 
}

sub download { 
}

sub build { 
}

sub install { 
}

sub new { 
	my $this = shift ; 
	my $class = ref($this) || $this ; 
	my $self = {} ; 
	bless $self, $class; 
	$self->{package} = __PACKAGE__ ; 
	$self->init(); 
	return $self; 
}

1;
