#!/usr/local/biotools/perl/5.14.2/bin/perl

use strict;
use warnings;

#check for presence of all i/p and o/p files
 if (scalar(@ARGV) != 3)
 {
 die ( "Usage:\nFillAnnotation.pl <allsamples.transcripts> <NotInMIT/NotInGencode> <Ouput file>\n" )
 }

my %hash1=();
my %hash2=();

open (FIRST,"$ARGV[0]") or die ("Could not open file to read $ARGV[0]\n");
while(my $line = <FIRST>)
{
	chomp $line;
	my @array = split('\t',$line);
	my @trans = split('_', $array[3]);
	my $uniq = join('_', $trans[0], $trans[1]);
	$hash1{$uniq} = join ("\t",$array[0], $array[1], $array[2], $uniq, $array[4]);
}
close FIRST;

open (SECOND,"$ARGV[1]");
while(my $line = <SECOND>)
{
	chomp $line;
	my @array = split('\t',$line);
	my @trans = split('_', $array[0]);
	my $uniq = join('_', $trans[0], $trans[1]);
	$hash2{$uniq} = join ("\t",@array);
}
close SECOND;

open (OUT, ">$ARGV[2]");

foreach my $find (sort keys %hash1)
{
	if(defined $hash2{$find})
	{
		print OUT "$hash1{$find}\t0\n";
	}
	else
	{
		print OUT "$hash1{$find}\t1\n";
	}
}
close OUT;
