package Tools::Verify::Cufflinks;

@ISA = qw(Tools::Verify); 

use Tools::Verify ; 
use strict ; 
use warnings ; 


sub init {
	my $self = shift ; 

	$self->{name} = 'Cufflinks'; 
	$self->{filename} = 'cufflinks'; 
	$self->{executable} = TRUE ; 
	$self->{min_version} = "2.1.1"; 
} 

sub getDescription { return "Cufflinks "; }

sub getConfigLabel { return "CUFFLINKS"; }

sub getConfigType { return "dir"; }

sub getSource { return "http://cufflinks.cbcb.umd.edu/downloads/cufflinks-2.1.1.Linux_x86_64.tar.gz"; }

sub getVersion { 
	my $self = shift ; 

	my $filename = $self->getPath(); 

	my $command = "$filename";
	my $output = $self->execute($command,1);

	my $version = undef ; 

	my @lines = split(/\n/, $output); 

	foreach my $thisLine (@lines){ 
		chomp($thisLine); 
		if($thisLine =~ /^cufflinks v/){ 
			$version = $thisLine ; 
			$version =~ s/^cufflinks v(\d+.\d+.\d+)$/$1/ ; 
		}
	}

	return $version ; 
}

sub download { 
}

sub build { 
}

sub install { 
}

sub new { 
	my $this = shift ; 
	my $class = ref($this) || $this ; 
	my $self = {} ; 
	bless $self, $class; 
	$self->{package} = __PACKAGE__ ; 
	$self->init(); 
	return $self; 
}

1;
