#!/usr/local/biotools/perl/5.14.2/bin/perl

## Perl script to extract common transcripts(obtained from cufflinks and scripture overlap) from the original cufflinks gtf file

use strict;
use warnings;

if (scalar(@ARGV) != 3)	
{
	die ( "Usage:\nextract_from_cufflinksGTF.pl <full path to original cufflinks GTF> <full path to file containing common transcripts> <Ouput file in GTF format>\n" );
}

my %hash1=();
my %hash2=();

#Form a unique key with chr@transcript
open (FIRST,"$ARGV[0]");
while(my $line = <FIRST>)	
{
	next if ($line =~ m/#/);
	chomp $line;
	my @array = split('\t',$line);
	my $uniq = $array[0];
	# my $value = $array[1].'@'.$array[2].'@'.$array[3].'@'.$array[4].'@'.$array[5].'@'.$array[6].'@'.$array[7].'@'.$array[8].'@'.$array[9];
	# push( @{$hash1{$uniq}},$value);
	push( @{$hash1{$uniq}},$line);
}
close FIRST;

#Form a unique key with chr@transcript
open (SECOND,"$ARGV[1]");
while(my $line = <SECOND>)	
{
	next if ($line =~ m/#/);
	chomp $line;
	my @array = split('\t',$line);
	my $uniq = $array[0];
	$hash2{$uniq} = $line;
}
close SECOND;

#Loop over unique key from %hash1 and compare with %hash2; print the result to OUT
open (OUT, ">$ARGV[2]");
foreach my $key (sort keys %hash2)	
{
	for (my $i=0;$i<=$#{$hash1{$key}};$i++)	
	{
		# my @value=split(/@/,$hash1{$key}[$i]); 
		my @value=split(/\t/,$hash1{$key}[$i]);
		print OUT join ("\t", @value) . "\n";
	}
}	

close OUT;



