use warnings;
use strict;

print "\nINFO - script to convert BED format to GTF format, with minimal info \n";
print "RAW paramters: @ARGV\n";
if (scalar(@ARGV) != 3)
{
	die ( "Usage: $0 \n\t [Input file] [Output file] [name that will be used as gene and transcript identifier]\n" );
}

else
{
	open (LIST,"$ARGV[0]");
	open (OUT,">$ARGV[1]");
	my $sample="$ARGV[2]";
	my $cnt;
    while (my $l = <LIST>)
	{
		chomp $l;
		$cnt++;
		my ($chr,$txStart,$txEnd,$name,$score,$strand,$thickStart,$thickEnd,$itemRgb,$exonCount,$exonSizes,$exonStarts) = split('\s+',$l);
		my @tr_name = split ('_',$name);
		my @e_start = split(/\,/,$exonStarts);
		my @e_size = split(/\,/,$exonSizes);
		my @e_stop=0;
		my $length = scalar (@e_start) - 1;
		for (my $i=0;$i<=$length;$i++)
		{

			$e_start[$i]=$e_start[$i]+$txStart;

			#### edited Jaysheel Bhavsar 11/18/2013
			#### Coordinates represented in BED files are Zero based.
			#### add 1 when converting BED file to GTF.
			$e_start[$i] += 1;

			$e_stop[$i]=($e_start[$i]+$e_size[$i]) - 1;

			my $id = "$chr\tMayoLincRNA\texon\t$e_start[$i]\t$e_stop[$i]\t1000\t$strand\t.\tgene_id \"$sample.$tr_name[0]_$tr_name[1]\"; transcript_id \"$tr_name[0]_$tr_name[1]\"";
			print OUT "$id"; print OUT "\n";
		}


    }
    close LIST;
	close OUT;

}
